VERSION 5.00
Begin VB.UserControl CapSample 
   BackColor       =   &H80000008&
   ClientHeight    =   6930
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   14640
   ScaleHeight     =   6930
   ScaleWidth      =   14640
   Begin VB.Frame frm_frames 
      Height          =   5550
      Index           =   1
      Left            =   1020
      TabIndex        =   1
      Top             =   1920
      Width           =   11550
      Begin VB.CheckBox chk_ASProduct 
         Caption         =   "#AS product"
         Height          =   195
         Left            =   5220
         TabIndex        =   50
         Tag             =   "chk_ASProduct"
         Top             =   1170
         Width           =   2235
      End
      Begin VB.TextBox txt_price 
         Height          =   315
         Left            =   6270
         MaxLength       =   10
         TabIndex        =   31
         Text            =   "txt_price"
         Top             =   735
         Width           =   840
      End
      Begin VB.TextBox txt_dropDate 
         Height          =   315
         Left            =   6240
         TabIndex        =   29
         Text            =   "Text1"
         Top             =   1995
         Width           =   1455
      End
      Begin VB.CheckBox chk_dropFlag 
         Caption         =   "#Dropped flag"
         Height          =   195
         Left            =   5220
         TabIndex        =   27
         Top             =   1725
         Width           =   2235
      End
      Begin VB.CheckBox chk_internet 
         Caption         =   "#Internet flag"
         Height          =   195
         Left            =   5220
         TabIndex        =   22
         Top             =   1440
         Width           =   2235
      End
      Begin VB.TextBox txt_spare4 
         Height          =   315
         Left            =   9825
         TabIndex        =   20
         Text            =   "Text1"
         Top             =   2025
         Visible         =   0   'False
         Width           =   1455
      End
      Begin VB.TextBox txt_spare2 
         Height          =   315
         Left            =   9825
         TabIndex        =   16
         Text            =   "Text1"
         Top             =   1395
         Visible         =   0   'False
         Width           =   1455
      End
      Begin VB.TextBox txt_spare1 
         Height          =   315
         Left            =   9825
         TabIndex        =   15
         Text            =   "Text1"
         Top             =   1095
         Visible         =   0   'False
         Width           =   1455
      End
      Begin VB.TextBox txt_spare3 
         Height          =   315
         Left            =   9825
         TabIndex        =   14
         Text            =   "Text1"
         Top             =   1695
         Visible         =   0   'False
         Width           =   1455
      End
      Begin Project1.ArmCheckView cvw_markets 
         Height          =   2205
         Left            =   1200
         TabIndex        =   12
         Top             =   1605
         Width           =   3225
         _ExtentX        =   5689
         _ExtentY        =   3889
      End
      Begin VB.TextBox txt_sample 
         Height          =   315
         Left            =   1200
         TabIndex        =   11
         Text            =   "Text1"
         Top             =   360
         Width           =   7395
      End
      Begin Project1.ArmCombobox cbo_group 
         Height          =   345
         Left            =   1200
         TabIndex        =   7
         Top             =   750
         Width           =   3285
         _ExtentX        =   5794
         _ExtentY        =   609
      End
      Begin VB.Frame frm_stock 
         Caption         =   "#Stock"
         Height          =   2640
         Left            =   5220
         TabIndex        =   34
         Tag             =   "frm_stock"
         Top             =   2550
         Width           =   6240
         Begin VB.CommandButton btn_qtyAddj 
            Caption         =   "#Qty add"
            Height          =   345
            Index           =   0
            Left            =   5100
            TabIndex        =   40
            Tag             =   "btn_qtyAddj"
            Top             =   600
            Visible         =   0   'False
            Width           =   1005
         End
         Begin VB.TextBox txt_smpMax 
            Height          =   285
            Index           =   0
            Left            =   3375
            TabIndex        =   38
            Text            =   "Text1"
            Top             =   660
            Visible         =   0   'False
            Width           =   735
         End
         Begin VB.TextBox txt_smpMin 
            Height          =   285
            Index           =   0
            Left            =   2580
            TabIndex        =   37
            Text            =   "Text1"
            Top             =   660
            Visible         =   0   'False
            Width           =   735
         End
         Begin VB.TextBox txt_smpQty 
            Height          =   285
            Index           =   0
            Left            =   1770
            TabIndex        =   36
            Text            =   "Text1"
            Top             =   660
            Visible         =   0   'False
            Width           =   735
         End
         Begin VB.CheckBox chk_smpDpt 
            Caption         =   "#Department"
            Height          =   225
            Index           =   0
            Left            =   180
            TabIndex        =   35
            Top             =   720
            Visible         =   0   'False
            Width           =   1530
         End
         Begin Project1.ArmCombobox cbo_UOM 
            Height          =   345
            Index           =   0
            Left            =   4200
            TabIndex        =   39
            Top             =   600
            Visible         =   0   'False
            Width           =   780
            _ExtentX        =   1376
            _ExtentY        =   609
         End
         Begin VB.Label lbl_labels 
            Alignment       =   2  'Center
            Caption         =   "#mtnc"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   18
            Left            =   5100
            TabIndex        =   45
            Tag             =   "lbl_smpMtnc"
            Top             =   315
            Width           =   735
         End
         Begin VB.Label lbl_labels 
            Alignment       =   2  'Center
            Caption         =   "#Max"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   17
            Left            =   3375
            TabIndex        =   44
            Tag             =   "lbl_smpMax"
            Top             =   315
            Width           =   735
         End
         Begin VB.Label lbl_labels 
            Alignment       =   2  'Center
            Caption         =   "#Min"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   16
            Left            =   2580
            TabIndex        =   43
            Tag             =   "lbl_smpMin"
            Top             =   315
            Width           =   735
         End
         Begin VB.Label lbl_labels 
            Alignment       =   2  'Center
            Caption         =   "#Qty"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   15
            Left            =   1770
            TabIndex        =   42
            Tag             =   "lbl_smpQty"
            Top             =   315
            Width           =   735
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Sample dept."
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   255
            Index           =   14
            Left            =   180
            TabIndex        =   41
            Tag             =   "lbl_smpDpt"
            Top             =   315
            Width           =   1530
         End
      End
      Begin Project1.ArmCombobox cbo_currency 
         Height          =   345
         Left            =   7305
         TabIndex        =   46
         Top             =   705
         Width           =   3990
         _ExtentX        =   7038
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_category 
         Height          =   345
         Left            =   1200
         TabIndex        =   48
         Top             =   1170
         Width           =   3285
         _ExtentX        =   5794
         _ExtentY        =   609
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Category"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   238
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   19
         Left            =   150
         TabIndex        =   49
         Tag             =   "lbl_category"
         Top             =   1215
         Width           =   945
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Price"
         Height          =   255
         Index           =   12
         Left            =   5205
         TabIndex        =   30
         Tag             =   "lbl_price"
         Top             =   795
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Drop date"
         Height          =   255
         Index           =   11
         Left            =   5220
         TabIndex        =   28
         Top             =   2085
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Spare4"
         Height          =   255
         Index           =   5
         Left            =   9195
         TabIndex        =   21
         Tag             =   "lb_spare2"
         Top             =   2055
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Spare2"
         Height          =   255
         Index           =   7
         Left            =   9195
         TabIndex        =   19
         Tag             =   "lb_spare2"
         Top             =   1425
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Spare1"
         Height          =   255
         Index           =   6
         Left            =   9195
         TabIndex        =   18
         Tag             =   "lb_spare1"
         Top             =   1125
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Spare3"
         Height          =   255
         Index           =   8
         Left            =   9195
         TabIndex        =   17
         Tag             =   "lb_spare2"
         Top             =   1725
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Markets"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   238
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   4
         Left            =   150
         TabIndex        =   10
         Top             =   1575
         Width           =   945
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Group"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   238
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   3
         Left            =   150
         TabIndex        =   9
         Top             =   840
         Width           =   945
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Sample"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   238
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   2
         Left            =   150
         TabIndex        =   8
         Top             =   390
         Width           =   945
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   13
      Top             =   0
      Width           =   10275
      _ExtentX        =   18124
      _ExtentY        =   1217
   End
   Begin VB.Frame frm_frames 
      Height          =   4935
      Index           =   0
      Left            =   60
      TabIndex        =   0
      Top             =   840
      Width           =   14535
      Begin Project1.ArmGrid grd_samples 
         Height          =   4155
         Left            =   150
         TabIndex        =   6
         Top             =   810
         Width           =   10215
         _ExtentX        =   18018
         _ExtentY        =   7329
      End
      Begin Project1.ArmCombobox cbo_market 
         Height          =   345
         Left            =   10410
         TabIndex        =   3
         Top             =   300
         Width           =   1935
         _ExtentX        =   3413
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_SmpType 
         Height          =   345
         Left            =   6255
         TabIndex        =   2
         Top             =   300
         Width           =   1605
         _ExtentX        =   2831
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_yearFoAct 
         Height          =   345
         Left            =   3360
         TabIndex        =   25
         Top             =   300
         Width           =   915
         _ExtentX        =   1614
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_dropped 
         Height          =   345
         Left            =   990
         TabIndex        =   26
         Top             =   300
         Width           =   855
         _ExtentX        =   1508
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_sampleDepartment 
         Height          =   345
         Left            =   13650
         TabIndex        =   33
         Top             =   300
         Width           =   1230
         _ExtentX        =   2170
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_SmpCategory 
         Height          =   345
         Left            =   7995
         TabIndex        =   47
         Top             =   300
         Width           =   1275
         _ExtentX        =   2249
         _ExtentY        =   609
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Department"
         Height          =   255
         Index           =   13
         Left            =   12390
         TabIndex        =   32
         Tag             =   "lbl_department"
         Top             =   390
         Width           =   1185
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Year of activity"
         Height          =   255
         Index           =   10
         Left            =   1980
         TabIndex        =   24
         Top             =   390
         Width           =   1275
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Dropped"
         Height          =   255
         Index           =   9
         Left            =   120
         TabIndex        =   23
         Top             =   390
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Market"
         Height          =   255
         Index           =   1
         Left            =   9450
         TabIndex        =   5
         Top             =   390
         Width           =   915
      End
      Begin VB.Label lbl_labels 
         Caption         =   "#Sample type/ category"
         Height          =   225
         Index           =   0
         Left            =   4440
         TabIndex        =   4
         Tag             =   "lbl_typeCategory"
         Top             =   420
         Width           =   1770
      End
   End
End
Attribute VB_Name = "CapSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SEP As String = SEP1 + SEP2
Private Const C_TOOLBARFACE_ITEM_LST As String = "0"
Private Const C_TOOLBARFACE_ITEM_MTNC As String = "1"
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "2"
Private Const C_DFT_QTY As String = "0"
Private Const C_DFT_MIN As String = "1"
Private Const C_DFT_MAX As String = "100"

Private Enum ArmErr
    DBCnxFailed = 2400              ' Unable to connect to the database
    CPTAl0readyInitialized = 2401    ' We try to initialize a component that is already initialized
    CPTNotInitialized = 2402        ' We try to use or free that is not initialized yet
    InvalidArgument = 2403
    PropertyNotSet = 2404
    CompFncFailed = 2405            ' when component function fail
    loginfailed = 2406              ' when Login fail
    InvalidValue = 2407             ' invalid version, invalid
    QuietException = 2408           ' do not display error message
End Enum

Public Enum UserLevels
    NotAssigned = 0
    AdminUser = 1
    translator = 2
    StockMngr = 4
End Enum

#If LIVE = 1 Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If
Private mInitialized As Boolean
Private mInitializing As Boolean
Private ml_U_Code As Long
Private ms_Language_Code As String    ' Language of user interface
Private ms_login As String              ' Login
Private ms_activeFace As String         ' active face
Private ml_DetailCursor As Long         ' cursor opened when entering detail
Private mo_userRights As UserRights_t   ' rights assigned for current user

Private Const LOCALE_USER_DEFAULT = &H400
Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private ms_DecimalSeparator  As String
Private ms_ThousandSeparator As String
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

Public Event quit()

Private Const SCREEN_NAME = "Cap_Sample"
Private Type UserRights_t
    
    Level As UserLevels
'    Logistic_market_code As String
    Translation_Languages As String
    StockDepartment As Long
End Type

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
    If mInitialized Then Call InitCtrlSize
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property

Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
    If mInitialized Then Call InitCtrlSize
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property

Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
    If mInitialized Then Call InitCtrlSize
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property

Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
    If mInitialized Then Call InitCtrlSize
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
    If mInitialized Then Call InitCtrlSize
End Sub

Public Property Set DB(ByRef aDb As ArmDb)
    Set mo_Db = aDb
End Property
Public Property Get Initialized() As Boolean
    Initialized = mInitialized
End Property
Public Property Let Ucode(ByVal aValue As Long)
On Error GoTo ErrHandler
    If aValue = 0 Then
        Call Err.Raise(CompFncFailed, "", "Wrong argument value (UCode=0). Check user settings please.")
    End If
    ml_U_Code = aValue
    Exit Property
ErrHandler:
    Call ErrorMessage("UCode(Let)")
End Property
Public Property Let Login(ByVal as_Value As String)
    ms_login = as_Value
End Property
Private Property Get Login() As String
    Login = ms_login
End Property
Public Property Let Language_Code(ByVal aValue As String)
    ' test if user is Polish
    ' GetCharSetFromCodePage = 238
'    If GetCharSetFromCodePage(GetDefaultConfigCode("Capture_Cfg", "Charset")) = 238 Then
'        Debug.Assert (AValue = "W")
'        ms_Language_Code = "E"      ' language for Polish people is "E"
'    Else
        ms_Language_Code = aValue
'    End If
End Property

Public Property Get Language_Code() As String
On Error GoTo ErrHandler
  Language_Code = ms_Language_Code
    Exit Property
ErrHandler:
    Call ErrorHandler("Language_Code(Get)")
End Property

Private Property Get ITEM_CODE() As Long
On Error GoTo ErrHandler
    If grd_samples.Row = -1 Then
        ITEM_CODE = 0
    Else
        ITEM_CODE = CLng(grd_samples.SelectedLine(0, "SDCODE"))
    End If
    Exit Property
    
ErrHandler:
    Call ErrorHandler("ITEM_CODE(Get)")
End Property


Private Property Get Language_codeToolBar() As String
On Error GoTo ErrHandler
    Language_codeToolBar = tlb_Main.Language
    Exit Property
ErrHandler:
    Call ErrorHandler("Language_codeToolBar(Get)")
End Property


Private Property Get SDG_CODE() As Long
On Error GoTo ErrHandler
    If cbo_SmpType.SelectedItem Is Nothing Then
        SDG_CODE = 0
    Else
        SDG_CODE = CLng(cbo_SmpType.SelectedItem.Key)
    End If
    Exit Property
    
ErrHandler:
    Call ErrorHandler("SDG_CODE(Get)")
End Property

Private Property Get LMK_CODE() As String
On Error GoTo ErrHandler
    If cbo_Market.SelectedItem Is Nothing Then
        LMK_CODE = ""
    Else
        LMK_CODE = cbo_Market.SelectedItem.Key
    End If
    Exit Property
    
ErrHandler:
    Call ErrorHandler("LMK_CODE(Get)")
End Property

Private Property Get SPD_Code() As Long
On Error GoTo ErrHandler
    If cbo_sampleDepartment.SelectedItem Is Nothing Then
        SPD_Code = 0
    Else
        SPD_Code = cbo_sampleDepartment.SelectedItem.Key
    End If
    Exit Property
    
ErrHandler:
    Call ErrorHandler("SPD_CODE(Get)")
End Property

Private Property Get SDC_CODE() As Long
On Error GoTo ErrHandler
    If cbo_SmpCategory.SelectedItem Is Nothing Then
        SDC_CODE = 0
    Else
        SDC_CODE = CLng(cbo_SmpCategory.SelectedItem.Key)
    End If
    Exit Property
    
ErrHandler:
    Call ErrorHandler("SDC_CODE(Get)")
End Property

Public Function Load_A_COM() As Boolean
    
On Error GoTo ErrHandler

    ml_DetailCursor = 0
    mo_userRights.Level = UserLevels.NotAssigned
    
    'to handle Decimal with the local settings
    Dim sBuffer As String
    Dim nBufferLen As Long
    mInitializing = True

    ms_DecimalSeparator = Format(0, ".")

    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    
    Call GetUserRight(mo_userRights)
    
    If mo_userRights.Level = AdminUser Then ms_Language_Code = "E"
    
    Set cbo_Market.ArmDb = mo_Db
    Set cbo_sampleDepartment.ArmDb = mo_Db
    Set cbo_SmpType.ArmDb = mo_Db
    Set cbo_Group.ArmDb = mo_Db
    Set cbo_Category.ArmDb = mo_Db
    Set cbo_Currency.ArmDb = mo_Db
    Set cbo_Dropped.ArmDb = mo_Db
    Set cbo_yearFoAct.ArmDb = mo_Db
    Set cbo_SmpCategory.ArmDb = mo_Db
    Set cvw_markets.ArmDb = mo_Db
    Set tlb_Main.ArmDb = mo_Db
    Set grd_samples.ArmDb = mo_Db
    
    cbo_Market.Load_A_COM
    cbo_sampleDepartment.Load_A_COM
    cbo_SmpType.Load_A_COM
    cbo_SmpCategory.Load_A_COM
    cbo_Group.Load_A_COM
    cbo_Category.Load_A_COM
    cbo_Currency.Load_A_COM
    cbo_Dropped.Load_A_COM
    cbo_yearFoAct.Load_A_COM
    cvw_markets.Load_A_COM
    tlb_Main.Load_A_COM
    grd_samples.Load_A_COM
    
    ' Initialize the toolbar
    tlb_Main.Language = ms_Language_Code
    
    ' init controls
    Call InitComponents
    Call LoadLabels(UserControl.Controls, SCREEN_NAME, ms_Language_Code)
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    
    ' set layout
    Call InitCtrlSize
    
    If cbo_sampleDepartment.SelectedItem Is Nothing Then
        ' if there is something selected then grid was already inicialized
        Call FillSampleGrid(grd_samples, 0, 0, "", 0, Language_codeToolBar, True)
    End If
    
    ' display starting face
    Call UpdateUI("SampleDoc.Main")
    
    mInitialized = True
    mInitializing = False
    Load_A_COM = True
    
    Exit Function

ErrHandler:
    Call ErrorMessage("Load_A_Com()")
    
End Function

Public Function Unload_A_COM() As Boolean
On Error GoTo ErrHandler

    cbo_Market.Unload_A_COM
    cbo_sampleDepartment.Unload_A_COM
    cbo_SmpType.Unload_A_COM
    cbo_SmpCategory.Unload_A_COM
    cbo_Group.Unload_A_COM
    cbo_Category.Unload_A_COM
    cbo_Currency.Unload_A_COM
    cbo_Dropped.Unload_A_COM
    cbo_yearFoAct.Unload_A_COM
    
    tlb_Main.Unload_A_COM
    
    grd_samples.Unload_A_COM
    
    cvw_markets.Unload_A_COM
    
    Set mo_Db = Nothing
    
    Unload_A_COM = True
    
    Exit Function

ErrHandler:
    If ml_DetailCursor <> 0 Then Call mo_Db.Close(ml_DetailCursor)
    Set mo_Db = Nothing
    Call ErrorHandler("Unload_A_Com()")
    
End Function


Private Sub UpdateUI(ByVal as_face As String)
On Error GoTo ErrHandler
    
    tlb_Main.Redraw = False
    
    ' set active face
    ms_activeFace = as_face
    
    ' apply face
    Dim lo_ctrl As Object
    Dim las_faces() As String, ls_face As Variant, ls_aktFace As String
    las_faces = Split(ms_activeFace, ".")
    
    For Each ls_face In las_faces
        ls_aktFace = IIf(ls_aktFace = "", ls_face, ls_aktFace & "." & ls_face)
        
        Select Case ls_aktFace
            Case "SampleDoc"
                ' hide all frames
                For Each lo_ctrl In frm_frames
                    lo_ctrl.Visible = False
                Next
                cvw_markets.Visible = True
                Set lo_ctrl = GetControl(lbl_labels, "lbl_markets")
                Debug.Assert (Not lo_ctrl Is Nothing)
                lo_ctrl.Visible = True

                chk_internet.Visible = True
                chk_DropFlag.Visible = True

            Case "SampleDoc.Main"
                ' we are in List section
                Set lo_ctrl = GetControl(frm_frames, "frm_main")
                lo_ctrl.Visible = True
                
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_LST)
               
            Case "SampleDoc.Upd"
                ' we are in Update section
                Set lo_ctrl = GetControl(frm_frames, "frm_detail")
                lo_ctrl.Visible = True
                If mo_userRights.Level And AdminUser Then
                    Call SetEnabled(GetContainedControls(lo_ctrl), True)
                    Call SetEnabledCtrl(chk_DropFlag, False)
                    Call SetEnabledCtrl(txt_DropDate, False)
                    Call SetEnabledCtrl(cbo_Currency, False)
                    ' disable group combo
                    Call SetEnabledCtrl(cbo_Group, False)
                    Call SetEnabledCtrl(cbo_Category, True)
                                    
                    Call cvw_markets.SetVisibleList("Edit")
                Else
                    Call SetEnabled(GetContainedControls(lo_ctrl), False)
                    Call cvw_markets.SetVisibleList("Main")
                End If
                
                If mo_userRights.Level And StockMngr Then
                    Call SetEnabledCtrl(frm_stock, True)
                Else
                    Call SetEnabled(GetContainedControls(frm_stock), False)
                End If
                
                Call SetEnabled(cbo_UOM, False)
                
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
                
            Case "SampleDoc.Tran"
                ' we are in Translate mode
                Set lo_ctrl = GetControl(frm_frames, "frm_detail")
                lo_ctrl.Visible = True
                Call SetEnabled(GetContainedControls(lo_ctrl), True)
                Call SetEnabledCtrl(chk_DropFlag, False)
                Call SetEnabledCtrl(txt_DropDate, False)
                Call SetEnabledCtrl(chk_internet, False)
                Call SetEnabledCtrl(chk_ASProduct, False)
                Call SetEnabledCtrl(txt_Price, False)
                Call SetEnabledCtrl(cbo_Currency, False)
                Call SetEnabled(GetContainedControls(frm_stock), False)
                
                ' disable group combo
                Call SetEnabledCtrl(cbo_Group, False)
                Call SetEnabledCtrl(cbo_Category, False)
                
                ' hide markets
                cvw_markets.Visible = False
                Set lo_ctrl = GetControl(lbl_labels, "lbl_markets")
                Debug.Assert (Not lo_ctrl Is Nothing)
                lo_ctrl.Visible = False
                
                ' hide internet flag
                chk_internet.Visible = False
                
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
                

            Case "SampleDoc.Add"
                ' we are in Add section
                Set lo_ctrl = GetControl(frm_frames, "frm_detail")
                lo_ctrl.Visible = True
                Call SetEnabled(GetContainedControls(lo_ctrl), True)
                Call SetEnabledCtrl(chk_DropFlag, False)
                Call SetEnabledCtrl(txt_DropDate, False)
                Call SetEnabledCtrl(cbo_Currency, False)
                Call SetEnabled(GetContainedControls(frm_stock), False)
            
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
                Call cvw_markets.SetVisibleList("Edit")
            
            Case "SampleDoc.View"
                ' we are in Delete section
                Set lo_ctrl = GetControl(frm_frames, "frm_detail")
                lo_ctrl.Visible = True
                Call SetEnabled(GetContainedControls(lo_ctrl), False)
                        
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
                Call cvw_markets.SetVisibleList("Main")
            
            Case "SampleDoc.Del"
                ' we are in Delete section
                Set lo_ctrl = GetControl(frm_frames, "frm_detail")
                lo_ctrl.Visible = True
                Call SetEnabled(GetContainedControls(lo_ctrl), False)
                        
                Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_MTNC)
                Call cvw_markets.SetVisibleList("Main")
        End Select
    Next
    
    Call ApplyRights(mo_userRights, Language_codeToolBar)

    tlb_Main.Redraw = True
    ' to display face immidiatelly
    UserControl.Refresh
    Exit Sub
ErrHandler:
    tlb_Main.Redraw = True
    Call ErrorHandler("UpdateUI()")
End Sub

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call SetEnabledCtrl(lo_ctrl, ab_value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler("SetEnabled()")
End Sub

Private Sub SetEnabledCtrl(ByRef ao_ctrl As Control, ByVal ab_value As Boolean)
On Error GoTo ErrHandler
        Select Case UCase(TypeName(ao_ctrl))
        Case "TEXTBOX"
            ao_ctrl.Locked = Not ab_value
            ao_ctrl.BackColor = IIf(ab_value, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
        Case "CHECKBOX", "TABSTRIP", "A_CALOCX", "ARMGRID", "ARMCOMBOBOX", "FRAME", "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX", "OPTIONBUTTON", "ARMTREEVIEW", "COMMANDBUTTON", "PICTUREBOX"
            ao_ctrl.Enabled = ab_value
        Case "LABEL", "ARMCHECKVIEW"
        Case Else
            Debug.Assert (False)
        End Select
     Exit Sub
ErrHandler:
     Call ErrorHandler("SetEnabledCtrl()")
End Sub


' ************************************************************************************
' ***************************** SECURITY FUNCTIONS ***********************************
' ************************************************************************************

Private Sub GetUserRight(ByRef ao_rights As UserRights_t)
Const C_REQ As String = "EXEC A_Config_sel 'CAP_SAMPLE_ADMIN'"
Const C_REQ2 As String = "EXEC A_Config_sel 'CAP_SAMPLE_TRAN'"
Const C_REQ3 As String = "EXEC A_Config_sel 'CAP_SAMPLE_STOCKMNGR'"
On Error GoTo ErrorHandler
    Dim ll_Cursor As Long
    Dim ll_Index As Long
    Dim lsa_users() As String
    
' check admin
    ll_Cursor = OpenSQLSafe(mo_Db, C_REQ)
    Debug.Assert (ll_Cursor <> 0)
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        lsa_users = Split(mo_Db.GetFields(ll_Cursor, 0), SEP1 + SEP2)
        For ll_Index = LBound(lsa_users) To UBound(lsa_users)
            If lsa_users(ll_Index) = ml_U_Code Then
                ao_rights.Level = UserLevels.AdminUser
                Exit For
            End If
        Next
    Else
        Call Err.Raise(CompFncFailed, "mo_db.RowCount", "Admin rights were not defined. Check definition of CAP_SAMPLE_ADMIN in A_Config.")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
' check translator
    ll_Cursor = OpenSQLSafe(mo_Db, C_REQ2)
    Debug.Assert (ll_Cursor <> 0)
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        lsa_users = Split(mo_Db.GetFields(ll_Cursor, 0), SEP1 + SEP2)
        For ll_Index = LBound(lsa_users) To UBound(lsa_users)
            Dim lsa_userLang() As String
            lsa_userLang = Split(lsa_users(ll_Index), SEP1)
            If UBound(lsa_userLang) - LBound(lsa_userLang) <> 1 Then
                Call Err.Raise(CompFncFailed, "", "Wrong content of translator definition. Check definition of CAP_SAMPLE_TRAN in A_Config.")
            End If
            If lsa_userLang(0) = ml_U_Code Then
                If ao_rights.Level = NotAssigned Then ao_rights.Level = ao_rights.Level Or UserLevels.translator
                ao_rights.Translation_Languages = lsa_userLang(1)
                Exit For
            End If
        Next
        
'        Dim lsa_LMK() As String
'        lsa_LMK = Split(mo_Db.GetFields(ll_Cursor, 0), SEP1 + SEP2)
'        For ll_Index = LBound(lsa_LMK) To UBound(lsa_LMK)
'            Dim lsa_marketUsers() As String
'            lsa_marketUsers = Split(lsa_LMK(ll_Index), SEP1)
'            If UBound(lsa_marketUsers) - LBound(lsa_marketUsers) <> 1 Then
'                Call Err.Raise(CompFncFailed, "", "Wrong content of rights definition. Check definition of CAP_SAMPLE_TRAN in A_Config.")
'            Else
'                If lsa_marketUsers(LBound(lsa_marketUsers)) = ml_U_code Then
'                    If ao_rights.Level = NotAssigned Then ao_rights.Level = UserLevels.Translator
'                    ao_rights.Logistic_market_code = lsa_marketUsers(LBound(lsa_marketUsers) + 1)
'                    Exit For
'                End If
'            End If
'        Next
    Else
        Call Err.Raise(CompFncFailed, "mo_db.RowCount", "Translator rights were not defined. Check definition of CAP_SAMPLE_TRAN in A_Config.")
    End If
    Call mo_Db.Close(ll_Cursor)
    
' check stock mngr
    ll_Cursor = OpenSQLSafe(mo_Db, C_REQ3)
    Debug.Assert (ll_Cursor <> 0)
    ao_rights.StockDepartment = 0
    
    If mo_Db.RowCount(ll_Cursor) > 0 Then
        lsa_users = Split(mo_Db.GetFields(ll_Cursor, 0), SEP1 + SEP2)
        For ll_Index = LBound(lsa_users) To UBound(lsa_users)
            Dim lsa_stock() As String
            lsa_stock = Split(lsa_users(ll_Index), SEP1)
            
            If lsa_stock(0) = ml_U_Code Then
                ao_rights.Level = ao_rights.Level Or UserLevels.StockMngr
                ao_rights.StockDepartment = lsa_stock(1)
                Exit For
            End If
        Next
    Else
        Call Err.Raise(CompFncFailed, "mo_db.RowCount", "Admin rights were not defined. Check definition of CAP_SAMPLE_ADMIN in A_Config.")
    End If
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
ErrorHandler:
    If ll_Cursor <> 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("GetUserRight()")
End Sub

Private Sub ApplyRights(ByRef ao_rights As UserRights_t, ByVal as_Lang As String)
On Error GoTo ErrHandler

    tlb_Main.Redraw = False
    
    
    tlb_Main.ButtonVisible("A") = False
    tlb_Main.ButtonVisible("E") = False
    tlb_Main.ButtonVisible("D") = False

    If ao_rights.Level And AdminUser Then
        tlb_Main.ButtonVisible("A") = (as_Lang = "E")
        ' update
        tlb_Main.ButtonVisible("E") = True
        ' delete
        tlb_Main.ButtonVisible("D") = (as_Lang = "E")
    End If
    
    If ao_rights.Level And translator Then
        tlb_Main.ButtonVisible("E") = tlb_Main.ButtonVisible("E") Or InStr(1, ao_rights.Translation_Languages, as_Lang, vbTextCompare)
    End If
    
    If ao_rights.Level And StockMngr Then
        tlb_Main.ButtonVisible("E") = tlb_Main.ButtonVisible("E") Or (as_Lang = "E")
    End If
    
    tlb_Main.Redraw = True
    Exit Sub
ErrHandler:
    Call ErrorHandler("ApplyRights()")
End Sub


' ************************************************************************************
' **************************** FRAMEWORK FUNCTIONS ***********************************
' ************************************************************************************

Private Function GetContainedControls(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control.Container Is CapSample Then
            If ao_parent.hwnd = lo_Control.Container.hwnd Then
                Call lo_retCollection.Add(lo_Control)
            End If
        End If
    Next
    Set GetContainedControls = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler("GetContainedControls()")
End Function

' as_Name is first part of Tag definition string
Private Function GetControl(ByVal ao_array As Object, ByVal as_Name As String) As Object
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_array
        If StrComp(lo_ctrl.Tag, as_Name, vbTextCompare) = 0 Then
            Set GetControl = lo_ctrl
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler("GetControl()")
End Function

' if ll_index is negative value string is indexed backward
Private Function GetString(ByVal as_String As String, ByVal ll_Index As Long, Optional ByVal as_delimiter As String = SEP) As String
On Error GoTo ErrHandler
    Dim lsa_tmpArray() As String
    lsa_tmpArray = Split(as_String, as_delimiter)
    
    If ll_Index < 0 Then ll_Index = ll_Index + UBound(lsa_tmpArray) + 1    ' backward index
    
    If UBound(lsa_tmpArray) >= ll_Index And LBound(lsa_tmpArray) <= ll_Index Then GetString = lsa_tmpArray(ll_Index)
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetString()")
End Function

Private Function LoadToolbars() As Boolean
On Error GoTo ErrHandler
    
    Const CL_REQUEST_TB As String = "SELECT Toolbar_Info FROM Toolbars_Users WHERE User_Code=$user_id$ AND App_Id=$App_Id$"
    Dim lc_Toolbar As Long
    Dim ls_ToolbarRequest As String, ls_ToolbarInfo As String

    ls_ToolbarRequest = Replace(CL_REQUEST_TB, "$user_id$", 0)
    ls_ToolbarRequest = Replace(ls_ToolbarRequest, "$App_Id$", 1)
    lc_Toolbar = OpenSQLSafe(mo_Db, ls_ToolbarRequest)
    ls_ToolbarInfo = mo_Db.GetFields(lc_Toolbar, "Toolbar_info")
    
    ' init toolbar
    tlb_Main.Language = ms_Language_Code
    Call tlb_Main.SetToolbarInfoStringParameters(ls_ToolbarInfo, "088")
    Call tlb_Main.DisplayFace("0")
    
    Call mo_Db.Close(lc_Toolbar)
    LoadToolbars = True
    Exit Function
ErrHandler:
    Call mo_Db.Close(lc_Toolbar)
    LoadToolbars = False
    Call ErrorHandler("LoadToolbars()")
End Function
    
Private Sub InitComponents()
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    
    Call LoadToolbars
    
    ' init tags for all controls
    frm_frames(0).Tag = "frm_main"
    frm_frames(1).Tag = "frm_detail"
    
    cbo_Market.Tag = "LMK_code" & SEP1 & "LMK_desc"
    cbo_SmpType.Tag = "SDG_code" & SEP1 & "SDG_desc"
    cbo_SmpCategory.Tag = "SDC_Code" & SEP1 & "SDC_Desc"
    cbo_Group.Tag = "SDG_code" & SEP1 & "SDG_desc"
    cbo_Category.Tag = "SDC_Code" & SEP1 & "SDC_Desc"
    cbo_Currency.Tag = "SD_CURR_Code" & SEP1 & "CURR_Desc"
    cbo_Dropped.Tag = "RF_code" & SEP1 & "RF_desc"
    cbo_yearFoAct.Tag = "FROMDATE" & SEP1 & "YearDesc"
    cbo_sampleDepartment.Tag = "SDP_Code" & SEP1 & "SDP_Desc"
    
    grd_samples.Tag = "grd_samples"
    
    txt_sample.Tag = "SD_desc"
    txt_DropDate.Tag = "drop_date"
    txt_spare1.Tag = "spare1_varchar"
    txt_spare2.Tag = "spare2_varchar"
    txt_spare3.Tag = "spare3_real"
    txt_spare4.Tag = "spare4_real"
    txt_Price.Tag = "SD_Price"
    
    chk_internet.Tag = "internet_flag"   ' TODO:
    chk_DropFlag.Tag = "drop_flag"
    chk_ASProduct.Tag = "AS_Product"
    
    lbl_labels(0).Tag = "lbl_sampleType"
    lbl_labels(1).Tag = "lbl_market"
    lbl_labels(2).Tag = "lbl_sample"
    lbl_labels(3).Tag = "lbl_group"
    lbl_labels(4).Tag = "lbl_markets"
    lbl_labels(5).Tag = "lbl_spare1"
    lbl_labels(6).Tag = "lbl_spare2"
    lbl_labels(7).Tag = "lbl_spare3"
    lbl_labels(8).Tag = "lbl_spare4"
    lbl_labels(9).Tag = "lbl_dropped"
    lbl_labels(10).Tag = "lbl_yearOfAct"
    lbl_labels(11).Tag = "lbl_dropDate"
    lbl_labels(12).Tag = "lbl_price"
    lbl_labels(19).Tag = "lbl_category"
    
    
    cvw_markets.Tag = "cvw_markets"
        
    ' set maxLength
    txt_sample.MaxLength = 150
    txt_spare1.MaxLength = 1
    txt_spare2.MaxLength = 1
    txt_spare3.MaxLength = 1
    txt_spare4.MaxLength = 1
    
    ' Initialize the grid
    grd_samples.UnBound = False
    grd_samples.FreeSelect = False
    grd_samples.AllowSort = True
    grd_samples.AllowExcelExport = True
    grd_samples.ExportTitles = True
    grd_samples.MultiSelect = False
    grd_samples.Title = "#Samples"
    
    If Not grd_samples.SetColumns(Array( _
      "SDCODE01SD_code#SD_code", _
      "SDDESCE35800SD_descE#Description English", _
      "SDDESC35800SD_desc#Description", _
      "SDGDESC13000SDG_desc#Group", _
      "DROPFLAG12000drop_flag#Drop flag", _
      "QTY12000SD_QTY#QuantityNumber###0", _
      "MIN12000SD_MIN#MinNumber###0", _
      "MAX12000SD_Max#MaxNumber###0", _
      "PRICE12000SD_Price#PriceNumber" & MONEY_FORMAT _
      )) Then
        Call Err.Raise(CompFncFailed, "grd_samples.SetColumns")
    End If
    
    If mo_userRights.Level And (AdminUser Or StockMngr) Then
        cbo_Market.FirstBlankItem = True
        cbo_Market.Request = "exec Cap_E_LogisticMarkets_lst " & "'" & ms_Language_Code & "'"
        tlb_Main.Language = "E"         ' JN to display Update icon
    Else
        cbo_Market.FirstBlankItem = True
        cbo_Market.Request = "SELECT LMK.LMK_code, LMK.LMK_desc FROM Security_Identity_LMK SIL " & _
                             " LEFT JOIN Logistic_Markets LMK ON LMK.LMK_code = SIL.LMK_code " & _
                             " WHERE SIL.Login_Name = sUser_sName() AND LMK.drop_flag <>'X' AND LMK.Language_code = '" & ms_Language_Code & "'"
    End If
    cbo_SmpType.FirstBlankItem = True
    cbo_SmpType.Request = "exec Cap_E_SampleDocGroup_cbo '" & ms_Language_Code & "'"
    cbo_SmpCategory.FirstBlankItem = True
    cbo_SmpCategory.Request = ""
    cbo_Group.FirstBlankItem = False
    cbo_Group.Request = "exec Cap_E_SampleDocGroup_cbo '" & ms_Language_Code & "'"
    cbo_Category.FirstBlankItem = False
    cbo_Category.Request = ""
    cbo_Currency.FirstBlankItem = False
    cbo_Currency.Request = "exec currencies_cbo2 '" & ms_Language_Code & "'"
    cbo_yearFoAct.Request = "SELECT YEAR(ISNULL(drop_date,z_creation)) AS FROMDATE, YEAR(ISNULL(drop_date,z_creation)) AS YearDesc " & _
                            "FROM Cap_SampleDoc GROUP BY YEAR(ISNULL(drop_date,z_creation)) ORDER BY YEAR(ISNULL(drop_date,z_creation)) desc"
    cbo_Dropped.Request = "EXEC A_References_ML_Lst 4, '" & ms_Language_Code & "'"
        
    cbo_sampleDepartment.FirstBlankItem = True
    cbo_sampleDepartment.Request = "EXEC Cap_SampleDepartment_lst '" & ms_Language_Code & "'"
    
    cvw_markets.RoleCount = 2
    cvw_markets.Driven_By = "Project"
    cvw_markets.Common_List_Load = True
    cvw_markets.Type_Of_Key = tkDependant
    cvw_markets.Calling_Key_Fields = "SD_codeLANG_CODEU_Code"
    cvw_markets.Calling_Key_Values = "0" & SEP & ms_Language_Code & SEP & ml_U_Code
    cvw_markets.HideColumnHeaders = False
    
    cvw_markets.Link_Key_Fields = "LMK_code"
    If Not cvw_markets.SetRoleList(Array( _
    Array("Main", "VIEW", "", "", "View", "LMK_codeLMK_descUsed", "LMK_descUsed", "2540800", "LMK_Code", "exec Cap_SampleDoc_Logistic_Markets_lst $SD_code$,'$LANG_CODE$'", "exec Cap_SampleDoc_Logistic_Markets_ins $SD_code$,'$LMK_Code$', $U_Code$", "exec Cap_SampleDoc_Logistic_Markets_del $SD_code$,'$LMK_Code$'", True, 2, False, True, 0, 1), _
    Array("Edit", "EDIT", "", "", "Edit", "LMK_codeLMK_descUsed", "LMK_descUsed", "2540800", "LMK_Code", "exec Cap_SampleDoc_Logistic_Markets_lst2 $SD_code$, '$LANG_CODE$'", "exec Cap_SampleDoc_Logistic_Markets_ins $SD_code$,'$LMK_Code$', $U_Code$", "exec Cap_SampleDoc_Logistic_Markets_del $SD_code$,'$LMK_Code$'", False, 2, False, True, 1, 0) _
    )) Then
        Call Err.Raise(1, "cvw_markets.SetRoleList", "Setting CheckView parameters failed.")
    End If
    Call cvw_markets.LoadConstants(CVptStatic, "LMK_desc#MarketsUsed#Used", CVctColumns)
    cvw_markets.Width = 3550
    cvw_markets.Synchronize_View = True
    cvw_markets.ComboVisible = False

    ' stock departments in detail screen
    
    Dim ll_Idx As Long
    Call cbo_sampleDepartment.Load
    For ll_Idx = 1 To cbo_sampleDepartment.Count
    
        If cbo_sampleDepartment.ComboItems(ll_Idx).Key <> "" Then
        
        Dim ll_Key As Long
        ll_Key = cbo_sampleDepartment.ComboItems(ll_Idx).Key
        
        Load chk_smpDpt(ll_Key)
        Call chk_smpDpt(ll_Key).Move(chk_smpDpt(0).Left, chk_smpDpt(0).Top + 350 * (ll_Idx - 1), chk_smpDpt(0).Width, chk_smpDpt(0).Height)
        chk_smpDpt(ll_Key).Caption = cbo_sampleDepartment.ComboItems(ll_Idx).DisplayText
        chk_smpDpt(ll_Key).Visible = True
        
        Load txt_smpQty(ll_Key)
        Call txt_smpQty(ll_Key).Move(txt_smpQty(0).Left, txt_smpQty(0).Top + 350 * (ll_Idx - 1), txt_smpQty(0).Width, txt_smpQty(0).Height)
        txt_smpQty(ll_Key).Visible = True
        
        Load txt_smpMin(ll_Key)
        Call txt_smpMin(ll_Key).Move(txt_smpMin(0).Left, txt_smpMin(0).Top + 350 * (ll_Idx - 1), txt_smpMin(0).Width, txt_smpMin(0).Height)
        txt_smpMin(ll_Key).Visible = True
        
        Load txt_smpMax(ll_Key)
        Call txt_smpMax(ll_Key).Move(txt_smpMax(0).Left, txt_smpMax(0).Top + 350 * (ll_Idx - 1), txt_smpMax(0).Width, txt_smpMax(0).Height)
        txt_smpMax(ll_Key).Visible = True
        
        Load cbo_UOM(ll_Key)
        Call cbo_UOM(ll_Key).Move(cbo_UOM(0).Left, cbo_UOM(0).Top + 350 * (ll_Idx - 1), cbo_UOM(0).Width, cbo_UOM(0).Height)
        cbo_UOM(ll_Key).Visible = True
        
        cbo_UOM(ll_Key).Load_A_COM
        Set cbo_UOM(ll_Key).ArmDb = mo_Db
        cbo_UOM(ll_Key).FirstBlankItem = False
        cbo_UOM(ll_Key).Tag = "SD_UM_Code" & SEP1 & "UM_Desc"
        cbo_UOM(ll_Key).Request = "EXEC unit_of_measure_cbo '" & ms_Language_Code & "'"
        Call cbo_UOM(ll_Key).Load
        
        Load btn_qtyAddj(ll_Key)
        Call btn_qtyAddj(ll_Key).Move(btn_qtyAddj(0).Left, btn_qtyAddj(0).Top + 350 * (ll_Idx - 1), btn_qtyAddj(0).Width, btn_qtyAddj(0).Height)
        btn_qtyAddj(ll_Key).Caption = btn_qtyAddj(0).Caption
        btn_qtyAddj(ll_Key).Visible = True
        End If
    Next
    
    If mo_userRights.StockDepartment <> 0 Then
        cbo_sampleDepartment.SearchItem (mo_userRights.StockDepartment)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitComponents()")
End Sub


Private Sub InitCtrlSize()
On Error GoTo ErrHandler

    Dim lLeft As Long, lTop As Long, lWidth As Long, lHeight As Long
    
    lLeft = 0
    lTop = 0
    lWidth = UserControl.Width - lLeft
    lHeight = UserControl.Height - lTop - 120
    Call tlb_Main.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 0
    lTop = tlb_Main.Top + tlb_Main.Height
    lWidth = UserControl.Width - lLeft
    lHeight = UserControl.Height - lTop
    
    Call frm_frames(0).Move(lLeft, lTop, lWidth, lHeight)
    Call frm_frames(1).Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = 120
    lTop = cbo_Market.Top + cbo_Market.Height + 120
    lWidth = frm_frames(0).Width - lLeft - 120
    lHeight = frm_frames(0).Height - lTop - 120
    Call grd_samples.Move(lLeft, lTop, lWidth, lHeight)
    
    lLeft = cvw_markets.Left
    lTop = cvw_markets.Top
    lWidth = cvw_markets.Width
    lHeight = frm_frames(1).Height - lTop - 120
    Call cvw_markets.Move(lLeft, lTop, lWidth, lHeight)
    

    Exit Sub
ErrHandler:
    Call ErrorHandler("InitCtrlSize()")
End Sub

' Load the labels of a containers
Public Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If lControl.Tag <> "" Then
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "CHECKBOX"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim ls_Text As String
                        Dim ll_titleIndex As Long
                        
                        ls_Text = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        ll_titleIndex = InStr(1, ls_Text, SEP)
                        
                        If Not lControl.LoadConstants(ptStatic, Left(ls_Text, ll_titleIndex - 1) & SEP & "LEFT", ctTopGrid) Then
'                            Call Err.Raise(CompFncFailed, "ArmGrid.LoadConstants", "Screen constant error.")
                        End If
                        
                        If Not lControl.LoadConstants(ptStatic, right(ls_Text, Len(ls_Text) - ll_titleIndex - 1), ctColumns) Then
'                            Call Err.Raise(CompFncFailed, "ArmGrid.LoadConstants", "Screen constant error.")
                        End If
                    End If
                Case "ARMCHECKVIEW"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        If Not lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), CVctColumns) Then
                            Call Err.Raise(CompFncFailed, "ArmCheckView.LoadConstants", "Screen constant error.")
                        End If
                    End If
                Case "FRAME", "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "COMMANDBUTTON", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
            Set lControl = Nothing
        End If
    Next
    
    mo_Db.Close (lLabels)

    Exit Sub

ErrHandler:
    Call ErrorHandler("LoadLabels")
End Sub

Private Sub FillSampleGrid(ByVal ao_grid As Object, ByVal al_SDG_code As Long, ByVal al_SDC_Code As Long, ByVal as_LMK_code As String, ByVal al_SPD_Code As Long, ByVal as_lang_code As String, ByVal ab_reloadIcon As Boolean)
On Error GoTo ErrHandler
Const REQ = "EXEC Cap_SampleDoc_load $SDG_CODE$, $SDC_CODE$, '$LMK_CODE$', $DROPVAL$, $ACTYEAR$, $SDP_CODE$, '$LANG_CODE$', $USERLEVEL$, '$LOGIN_NAME$'"
    
    Dim ls_req As String
    Dim lo_array As Collection
    ao_grid.ClearGrid
    
    ' change charset
    Set lo_array = New Collection
    
    ' controls that are language dependent of selected language, except grids - grids are set in fill functions
    Call lo_array.Add(ao_grid)
    Call lo_array.Add(txt_sample)
    
    Dim ls_CodePage As String
    ls_CodePage = GetCodePageFromLanguage(mo_Db, as_lang_code)
    
    Call ChangeCharset(lo_array, ls_CodePage)
    grd_samples.LocalID = GetLCIDFromCodePage(ls_CodePage)
    
    Set lo_array = Nothing

    ls_req = Replace(REQ, "$SDG_CODE$", al_SDG_code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$SDC_CODE$", al_SDC_Code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$LMK_CODE$", as_LMK_code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$SDP_CODE$", al_SPD_Code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$DROPVAL$", SQLComboBoxValue(cbo_Dropped, 1), , , vbTextCompare)
    ls_req = Replace(ls_req, "$ACTYEAR$", SQLComboBoxValue(cbo_yearFoAct, "Null"), , , vbTextCompare)
    
    ls_req = Replace(ls_req, "$LANG_CODE$", as_lang_code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$USERLEVEL$", mo_userRights.Level, , , vbTextCompare)
    ls_req = Replace(ls_req, "$LOGIN_NAME$", ms_login, , , vbTextCompare)
    'ls_req = Replace(ls_req, "$LMK_TRANCODE$", mo_userRights.Logistic_market_code)
    
    If Not ao_grid.Load(ls_req, False, , , ab_reloadIcon) Then
        Call Err.Raise(CompFncFailed, "ao_grid.Load")
    End If
    Exit Sub
ErrHandler:
    If Not lo_array Is Nothing Then Set lo_array = Nothing
    Call ErrorHandler("FillSampleGrid()")
End Sub

Private Function GetDateTime(ByVal as_val As String) As Date
On Error GoTo ErrHandler
    If IsDate(as_val) Then
        GetDateTime = DateValue(as_val)
    Else
        GetDateTime = 0
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDateTime()")
End Function

Private Sub ResetDetail(ByVal al_DetailCursor As Long)
On Error GoTo ErrHandler
    Dim lo_cbo As Object
    Dim lb_hasRight As Boolean
    
    mInitializing = True

    If al_DetailCursor = 0 Then
        txt_sample.Text = ""
        txt_DropDate.Text = ""
        txt_spare1.Text = ""
        txt_spare2.Text = ""
        txt_spare3.Text = "0"
        txt_spare4.Text = "0"
        chk_internet.Value = CheckBoxConstants.vbUnchecked
        chk_DropFlag.Value = CheckBoxConstants.vbUnchecked
        chk_ASProduct.Value = CheckBoxConstants.vbUnchecked
        txt_Price.Text = ""
                
        Set cbo_Group.SelectedItem = Nothing
        Call cbo_Category.Clear
        If Not cbo_Currency.SearchItem("EUR") Then          ' price is allways in EUR
            cbo_Currency.Load
            Call cbo_Currency.SearchItem("EUR")
        End If
        
        ' reset edit list
        cvw_markets.Calling_Key_Values = "0" & SEP & ms_Language_Code & SEP & ml_U_Code
        Call cvw_markets.LoadEditLists
        ' load selected items
        Call cvw_markets.LoadList
        
        For Each lo_cbo In cbo_UOM
            Call lo_cbo.SearchItem("PC")
            chk_smpDpt(lo_cbo.Index).Value = vbUnchecked
            txt_smpQty(lo_cbo.Index).Text = ""
            txt_smpQty(lo_cbo.Index).Tag = ""
            txt_smpMin(lo_cbo.Index).Text = ""
            txt_smpMax(lo_cbo.Index).Text = ""
            btn_qtyAddj(lo_cbo.Index).Tag = 0
            
            lb_hasRight = (mo_userRights.StockDepartment = lo_cbo.Index)
            
            Call SetEnabledCtrl(chk_smpDpt(lo_cbo.Index), lb_hasRight)
            Call SetEnabledCtrl(txt_smpQty(lo_cbo.Index), False)                ' qty disabled allways
            Call SetEnabledCtrl(txt_smpMin(lo_cbo.Index), False)                ' disabled for unchecked
            Call SetEnabledCtrl(txt_smpMax(lo_cbo.Index), False)                ' disabled for unchecked
            Call SetEnabledCtrl(btn_qtyAddj(lo_cbo.Index), False)               ' disabled for unchecked
            
        Next
        
    Else

        txt_sample.Text = mo_Db.GetFields(ml_DetailCursor, txt_sample.Tag)
        txt_DropDate.Text = IIf(mo_Db.GetFields(ml_DetailCursor, txt_DropDate.Tag) = 0, "", Format(mo_Db.GetFields(ml_DetailCursor, txt_DropDate.Tag), "d/m/yyyy"))
        txt_spare1.Text = mo_Db.GetFields(ml_DetailCursor, txt_spare1.Tag)
        txt_spare2.Text = mo_Db.GetFields(ml_DetailCursor, txt_spare2.Tag)
        txt_spare3.Text = mo_Db.GetFields(ml_DetailCursor, txt_spare3.Tag)
        txt_spare4.Text = mo_Db.GetFields(ml_DetailCursor, txt_spare4.Tag)
        chk_internet.Value = IIf(mo_Db.GetFields(ml_DetailCursor, chk_internet.Tag) = "X", vbChecked, vbUnchecked)
        chk_DropFlag.Value = IIf(mo_Db.GetFields(ml_DetailCursor, chk_DropFlag.Tag) = "X", vbChecked, vbUnchecked)
        txt_Price.Text = mo_Db.GetFields(ml_DetailCursor, txt_Price.Tag)
        chk_ASProduct.Value = IIf(mo_Db.GetFields(ml_DetailCursor, chk_ASProduct.Tag) = "X", vbChecked, vbUnchecked)

        Call SetCboItem(ml_DetailCursor, cbo_Group)
        Call cbo_Category.Clear
        cbo_Category.Request = "EXEC Cap_SampleDocCategory_lst " & cbo_Group.SelectedItem.Key & ",'" & ms_Language_Code & "'"
        Call SetCboItem(ml_DetailCursor, cbo_Category)
        Call SetCboItem(ml_DetailCursor, cbo_Currency)
        
        cvw_markets.Calling_Key_Values = mo_Db.GetFields(ml_DetailCursor, "SD_code") & SEP & ms_Language_Code & SEP & ml_U_Code
        ' reset edit list
        Call cvw_markets.LoadEditLists
        ' load selected items
        Call cvw_markets.LoadList
    
        Dim lo_CheckList As ArmCheckList
        Dim lo_item As ArmItemInfo
        Set lo_CheckList = cvw_markets.RoleList("Edit")
        For Each lo_item In lo_CheckList.Items
            lo_item.ReadOnly = (lo_item.GetData(2) = "X")
        Next
        
        Dim ll_Cursor As Long
        ll_Cursor = OpenSQLSafe(mo_Db, "EXEC Cap_SampleDoc_Department_lst " & ITEM_CODE)
        
        For Each lo_cbo In cbo_UOM
            If Not lo_cbo.SearchItem(mo_Db.GetFields(ml_DetailCursor, GetString(lo_cbo.Tag, 0, SEP1)), 0) Then Call lo_cbo.AddItem(Array(mo_Db.GetFields(ml_DetailCursor, GetString(lo_cbo.Tag, 0, SEP1)), mo_Db.GetFields(ml_DetailCursor, GetString(lo_cbo.Tag, 1, SEP1))), True)
            
            If mo_Db.FindBinary(ll_Cursor, "SDP_Code", lo_cbo.Index) >= 0 Then
                chk_smpDpt(lo_cbo.Index).Value = vbChecked
                txt_smpQty(lo_cbo.Index).Text = mo_Db.GetFields(ll_Cursor, "SD_Qty")
                txt_smpQty(lo_cbo.Index).Tag = txt_smpQty(lo_cbo.Index).Text
                txt_smpMin(lo_cbo.Index).Text = mo_Db.GetFields(ll_Cursor, "SD_Min")
                txt_smpMax(lo_cbo.Index).Text = mo_Db.GetFields(ll_Cursor, "SD_Max")
                btn_qtyAddj(lo_cbo.Index).Tag = mo_Db.GetFields(ll_Cursor, "iConcurrency")
            Else
                chk_smpDpt(lo_cbo.Index).Value = vbUnchecked
                txt_smpQty(lo_cbo.Index).Text = ""
                txt_smpQty(lo_cbo.Index).Tag = ""
                txt_smpMin(lo_cbo.Index).Text = ""
                txt_smpMax(lo_cbo.Index).Text = ""
                btn_qtyAddj(lo_cbo.Index).Tag = 0
            End If
            
            lb_hasRight = (mo_userRights.StockDepartment = lo_cbo.Index)
            
            Call SetEnabledCtrl(chk_smpDpt(lo_cbo.Index), lb_hasRight)
            Call SetEnabledCtrl(txt_smpQty(lo_cbo.Index), False)                     ' allways locked when in update mode
            
            lb_hasRight = lb_hasRight And (chk_smpDpt(lo_cbo.Index).Value = vbChecked)  ' disabled for unchecked
            Call SetEnabledCtrl(txt_smpMin(lo_cbo.Index), lb_hasRight)
            Call SetEnabledCtrl(txt_smpMax(lo_cbo.Index), lb_hasRight)
            Call SetEnabledCtrl(btn_qtyAddj(lo_cbo.Index), lb_hasRight)
        Next
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    mInitializing = False
    
    Exit Sub
ErrHandler:
    mInitializing = False
    
    If ll_Cursor <> 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("ResetDetail()")
End Sub

Private Function Item_Add() As String
On Error GoTo ErrHandler
    Dim ls_SDcode As String
    Item_Add = ""
    If Item_Check() Then
        ls_SDcode = mo_Db.SQLNextID("CAP_SD_CODE")
        If ls_SDcode = "" Then
            Call Err.Raise(CompFncFailed, "SQLNextID", "CAP_SD_CODE must exist in A_ID.")
        End If
        Debug.Assert (isNumeric(ls_SDcode))
        Item_Add = ls_SDcode
        
        Call Item_AddDB(CLng(ls_SDcode))
    Else
        Call Err.Raise(QuietException)
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Add()")
End Function

' update actualy selected item from BLOB_ID
Private Function Item_Update() As String
On Error GoTo ErrHandler
    Dim ls_SDcode As String
    Item_Update = ""
    If Item_Check() Then
    
        ls_SDcode = CStr(ITEM_CODE)
        If Not Item_UpdateDB(CLng(ls_SDcode), mo_Db.GetFields(ml_DetailCursor, "iConcurrency")) Then
            ' iConcurrency error/ detail needs to be updated
            If Item_RefreshData(CLng(ls_SDcode), Language_codeToolBar, ml_DetailCursor) Then
                ls_SDcode = ""        ' repeat update screen
                MsgBox ("Record was updated by another user. Try again, please.")
                ' redisplay data
                Call ResetDetail(ml_DetailCursor)
            Else
                ' record was deleted by another user
                ' change face to 'Del' to let tool delete row from grid
                ms_activeFace = "SampleDoc.Del"
                MsgBox ("Record was deleted by another user. Click Add to create new record.")
            End If
        End If
        
        Item_Update = ls_SDcode
    Else
        ' Item_Check also display msgbox
        Call Err.Raise(QuietException)
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Update()")
End Function

' update actualy selected item from BLOB_ID
Private Function Item_Translate() As String
On Error GoTo ErrHandler
    Dim ls_SDcode As String
    Item_Translate = ""
    If Item_Check() Then
    
        ls_SDcode = CStr(ITEM_CODE)
        If Not Item_TranslateDB(CLng(ls_SDcode), mo_Db.GetFields(ml_DetailCursor, "iConcurrency")) Then
            ' iConcurrency error/ detail needs to be updated
            If Item_RefreshData(CLng(ls_SDcode), Language_codeToolBar, ml_DetailCursor) Then
                ls_SDcode = ""        ' repeat update screen
                MsgBox ("Record was updated by another user. Try again, please.")
                ' redisplay data
                Call ResetDetail(ml_DetailCursor)
            Else
                ' record was deleted by another user
                ' change face to 'Del' to let tool delete row from grid
                ms_activeFace = "SampleDoc.Del"
                MsgBox ("Record was deleted by another user. Click Add to create new record.")
            End If
        End If
        
        Item_Translate = ls_SDcode
    Else
        ' Item_Check also display msgbox
        Call Err.Raise(QuietException)
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Translate()")
End Function

' delete actualy selected item from
Private Function Item_Delete() As String
On Error GoTo ErrHandler
    Dim ls_SDcode As String

    ' SINCE TASK 289, USER CAN DELETE SAMPLE EVEN IT IS USED IN SYSTEM
    ' Check if the item can be deleted
'    Dim lo_CheckList As ArmCheckList
'    Dim lo_Item As ArmItemInfo
'    Set lo_CheckList = cvw_markets.RoleList("Edit")
'    For Each lo_Item In lo_CheckList.Items
'        If lo_Item.GetData(2) = "X" Then
'            MsgBox "You cannot delete this item because it's used in at least on market"
'            Exit Function
'        End If
'    Next


    ls_SDcode = CStr(ITEM_CODE)
    Debug.Assert (isNumeric(ls_SDcode))
    If MsgBox("Delete record?", vbYesNo) = vbYes Then
        chk_DropFlag.Value = CheckBoxConstants.vbChecked
        If Not Item_DeleteDB(CLng(ls_SDcode), mo_Db.GetFields(ml_DetailCursor, "iConcurrency")) Then
            chk_DropFlag.Value = CheckBoxConstants.vbUnchecked
            ' iConcurrency error/ detail needs to be updated
            If Item_RefreshData(CLng(ls_SDcode), Language_codeToolBar, ml_DetailCursor) Then
                ls_SDcode = ""        ' repeat delete screen
                MsgBox ("Record was updated by another user. Try again, please.")
                ' redisplay data
                Call ResetDetail(ml_DetailCursor)
            End If
        End If
    Else
        ls_SDcode = ""        ' repeat delete screen
    End If
    
    Item_Delete = ls_SDcode
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Delete()")
End Function

Private Sub Item_ExitToGrid(ByVal av_SDcode As Variant)
On Error GoTo ErrHandler
    ' update grid on main screen
    Debug.Assert (isNumeric(av_SDcode(0)))
    Call UpdateGridAfterAction(grd_samples, GetString(ms_activeFace, -1, "."), av_SDcode)
    
    ' close detailCursor
    Call mo_Db.Close(ml_DetailCursor)
    ml_DetailCursor = 0
    
    ' prepare user interface for main screen
    Call UpdateUI("SampleDoc.Main")
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_ExitToGrid()")
End Sub

' open/reopen detail cursor
Private Sub Item_LoadDB(ByRef al_DetailCursor As Long, ByVal al_SDCode As Long, ByVal as_lang_code As String)
On Error GoTo ErrHandler
Const REQ = "EXEC Cap_SampleDoc_sel2 $SD_CODE$, '$LANG_CODE$'"
    
    If al_DetailCursor <> 0 Then Call mo_Db.Close(al_DetailCursor)
    al_DetailCursor = 0
    
    Dim ls_req As String
    
    ls_req = Replace(REQ, "$LANG_CODE$", as_lang_code)
    ls_req = Replace(ls_req, "$SD_CODE$", CStr(al_SDCode))
    
    al_DetailCursor = OpenSQLSafe(mo_Db, ls_req)
    Debug.Assert (al_DetailCursor <> 0)
    
    If mo_Db.RowCount(al_DetailCursor) = 0 Then
        ' record was probably deleted
        Call mo_Db.Close(al_DetailCursor)
        al_DetailCursor = 0
        Exit Sub
    End If
    
    Call mo_Db.First(al_DetailCursor)
    
    Exit Sub
ErrHandler:
    If al_DetailCursor <> 0 Then Call mo_Db.Close(al_DetailCursor)
    al_DetailCursor = 0
    Call ErrorHandler("Item_LoadDB()")
End Sub

Private Function CheckNumericField(ByVal ao_value As TextBox, ByVal ai_NbDecimal As Integer, ByVal av_Min As Variant, ByVal av_Max As Variant) As Long
On Error GoTo ErrHandler
    Dim ls_value As Variant
    
    ls_value = Replace(ao_value.Text, ".", ms_DecimalSeparator, , , vbTextCompare)
    
    
    On Error Resume Next
    Dim ld_Number As Double
    Dim ll_errnum As Long
    ld_Number = CDbl(ls_value)
    ll_errnum = Err.Number
    Err.Clear
    On Error GoTo ErrHandler
    If ll_errnum <> 0 Then
        CheckNumericField = 2131
        GoTo BackToControl
    End If

    If InStr(1, ls_value, "e", vbTextCompare) Or InStr(1, ls_value, ms_ThousandSeparator, vbTextCompare) Then
        CheckNumericField = 2131
        GoTo BackToControl
    End If
    
    If ai_NbDecimal = 0 And InStr(1, ls_value, ms_DecimalSeparator) Then
        CheckNumericField = 2134
        GoTo BackToControl
    End If
    
    ' we only accept decimal separators
    
    If ld_Number <> Val(Replace(ls_value, ms_DecimalSeparator, ".", , , vbTextCompare)) Then
        CheckNumericField = 2134
        GoTo BackToControl
    End If
    
    If Not (ld_Number >= av_Min And ld_Number <= av_Max) Then
        CheckNumericField = 2132
        GoTo BackToControl
    End If

    CheckNumericField = 0
    
    Exit Function

BackToControl:
    ao_value.SelStart = 0
    ao_value.SelLength = Len(ao_value.Text)
    If ao_value.Visible And ao_value.Enabled Then
        ao_value.SetFocus
        DoEvents
    End If
    
    Exit Function

ErrHandler:
    Call ErrorHandler("CheckNumericField")
   
End Function

' RESTORE DETAIL AND MAIN SCREEN FROM DB AND REFRESH DETAIL CURSOR
Private Function Item_RefreshData(ByVal al_SDCode As Long, ByVal as_lang_code As String, ByRef al_DetailCursor As Long) As Boolean
On Error GoTo ErrHandler
    Debug.Assert (ITEM_CODE = al_SDCode)
    
    Dim lo_Column As ArmColumn
    Dim ll_Index As Long, ll_FieldIndex As Long
    
    ' refresh cursor
    Call Item_LoadDB(al_DetailCursor, al_SDCode, as_lang_code)
    If al_DetailCursor = 0 Then
        Item_RefreshData = False
        Exit Function
    End If
    
    ' refresh grid
    Debug.Assert (grd_samples.Row <> -1)
    For ll_Index = 0 To grd_samples.Cols - 1
        Set lo_Column = grd_samples.Columns(ll_Index)
        ll_FieldIndex = mo_Db.GetFieldIndex(al_DetailCursor, lo_Column.FieldName)
        If ll_FieldIndex <> -1 Then Call lo_Column.SetData(grd_samples.Row, mo_Db.GetFields(al_DetailCursor, ll_FieldIndex))
    Next

    Item_RefreshData = True
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_RefreshData()")
End Function

Private Function Item_Check() As Boolean
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    Item_Check = False
    Dim ll_errCode As Long
    
    Select Case GetString(ms_activeFace, -1, ".")
    Case "Add", "Upd"
        If cbo_Group.SelectedItem Is Nothing Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_group")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, cbo_Group)
            Exit Function
        End If
        
        If cbo_Category.SelectedItem Is Nothing Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_category")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, cbo_Category)
            Exit Function
        End If
        
        If Trim(txt_Price.Text) = "" Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_price")
            Call FieldErrorMsg(966, lo_ctrl.Caption, txt_Price)
            Exit Function
        End If

        ll_errCode = CheckNumericField(txt_Price, 2, 0, 9999999)
        If ll_errCode <> 0 Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_price")
            Call FieldErrorMsg(ll_errCode, lo_ctrl.Caption, txt_Price, "0", "9999999")
            Exit Function
        End If

        If cbo_Currency.SelectedItem Is Nothing Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_price")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, cbo_Currency)
            Exit Function
        End If
        
        If txt_sample.Text = "" Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_sample")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, txt_sample)
            Exit Function
        End If
        
        If cvw_markets.CheckedCount("Edit") = 0 Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_markets")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, cvw_markets)
            Exit Function
        End If
        
        Dim lo_cbo As Object
        Dim ll_SPD_Code As Long
        
        For Each lo_cbo In cbo_UOM
            ll_SPD_Code = lo_cbo.Index
            
            If mo_userRights.StockDepartment = ll_SPD_Code Then
            
                If chk_smpDpt(ll_SPD_Code).Value = vbChecked Then
                    ' check values
                    If Trim(txt_smpQty(ll_SPD_Code).Text) = "" Then
                        Set lo_ctrl = GetControl(lbl_labels, "lbl_smpQty")
                        Call FieldErrorMsg(966, lo_ctrl.Caption, txt_smpQty(ll_SPD_Code))
                        Exit Function
                    End If
                    If Trim(txt_smpMax(ll_SPD_Code).Text) = "" Then
                        Set lo_ctrl = GetControl(lbl_labels, "lbl_smpMax")
                        Call FieldErrorMsg(966, lo_ctrl.Caption, txt_smpMax(ll_SPD_Code))
                        Exit Function
                    End If
                    
                    If Trim(txt_smpMin(ll_SPD_Code).Text) = "" Then
                        Set lo_ctrl = GetControl(lbl_labels, "lbl_smpMin")
                        Call FieldErrorMsg(966, lo_ctrl.Caption, txt_smpMin(ll_SPD_Code))
                        Exit Function
                    End If
                    
                    ll_errCode = CheckNumericField(txt_smpQty(ll_SPD_Code), 0, 0, 9999999)
                    If ll_errCode <> 0 Then
                        Set lo_ctrl = GetControl(lbl_labels, "lbl_smpQty")
                        Call FieldErrorMsg(ll_errCode, lo_ctrl.Caption, txt_smpQty(ll_SPD_Code), "0", "9999999")
                        Exit Function
                    End If
                    If Trim(txt_smpMax(ll_SPD_Code).Text) <> "" Then
                        ll_errCode = CheckNumericField(txt_smpMax(ll_SPD_Code), 0, 0, 9999999)
                        If ll_errCode <> 0 Then
                            Set lo_ctrl = GetControl(lbl_labels, "lbl_smpMax")
                            Call FieldErrorMsg(ll_errCode, lo_ctrl.Caption, txt_smpMax(ll_SPD_Code), "0", "9999999")
                            Exit Function
                        End If
                    End If
                    If Trim(txt_smpMin(ll_SPD_Code).Text) <> "" Then
                        ll_errCode = CheckNumericField(txt_smpMin(ll_SPD_Code), 0, 0, 9999999)
                        If ll_errCode <> 0 Then
                            Set lo_ctrl = GetControl(lbl_labels, "lbl_smpMin")
                            Call FieldErrorMsg(ll_errCode, lo_ctrl.Caption, txt_smpMin(ll_SPD_Code), "0", "9999999")
                            Exit Function
                        End If
                    End If
                    
                    If Trim(txt_smpMax(ll_SPD_Code).Text) <> "" And Trim(txt_smpMin(ll_SPD_Code).Text) <> "" Then
                        If CDbl(txt_smpMax(ll_SPD_Code).Text) < CDbl(txt_smpMin(ll_SPD_Code).Text) Then
                            Call MsgBox(MsgText(984, ms_Language_Code, "#Quantity Max is less than Min."), vbOKOnly)
                            Exit Function
                        End If
                    End If


                End If
            End If
        Next

    Case "Tran"
        Debug.Assert (Not cbo_Group.SelectedItem Is Nothing)
        Debug.Assert (Not cbo_Category.SelectedItem Is Nothing)
        Debug.Assert (Not cbo_Currency.SelectedItem Is Nothing)
        Debug.Assert (cvw_markets.CheckedCount("Edit") > 0)
        
        If txt_sample.Text = "" Then
            Set lo_ctrl = GetControl(lbl_labels, "lbl_sample")
            Debug.Assert (Not lo_ctrl Is Nothing)
            
            Call FieldErrorMsg(966, lo_ctrl.Caption, txt_sample)
            Exit Function
        End If
    
    Case "Del"
        Debug.Assert (False)
    Case Else
        Debug.Assert (False)
    End Select
    
    
    Item_Check = True
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Check()")
End Function

Private Sub Item_AddInit()
On Error GoTo ErrHandler

    Call ResetDetail(0)
    Call UpdateUI("SampleDoc.Add")
    ' set focus to txt_sample
    Debug.Assert (txt_sample.Visible = True)
    Call txt_sample.SetFocus

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_AddInit()")
End Sub

Private Sub Item_UpdateInit()
On Error GoTo ErrHandler
    ' data to be edited must be selected in main screen
    Debug.Assert (grd_samples.Row <> -1)
    
    Call Item_LoadDB(ml_DetailCursor, ITEM_CODE, Language_codeToolBar)
    If ml_DetailCursor = 0 Then
        Call Err.Raise(CompFncFailed, "", "Record was deleted or translation for language is missing." & vbCrLf & "Refresh grid, please.")
    End If
    Debug.Assert (ml_DetailCursor <> 0)
    Call ResetDetail(ml_DetailCursor)
    Call UpdateUI("SampleDoc.Upd")
    ' set focus to txt_sample
    Debug.Assert (txt_sample.Visible = True)
    Call txt_sample.SetFocus

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateInit()")
End Sub

Private Sub Item_DeleteInit()
On Error GoTo ErrHandler
    ' data to be deleted must be selected in main screen
    Debug.Assert (grd_samples.Row <> -1)
    Call Item_LoadDB(ml_DetailCursor, ITEM_CODE, Language_codeToolBar)
    If ml_DetailCursor = 0 Then
        Call Err.Raise(CompFncFailed, "", "Record was deleted or translation for language is missing." & vbCrLf & "Refresh grid, please.")
    End If
    Debug.Assert (ml_DetailCursor <> 0)
    Call ResetDetail(ml_DetailCursor)
    Call UpdateUI("SampleDoc.Del")

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_DeleteInit()")
End Sub

Private Sub Item_ViewInit()
On Error GoTo ErrHandler
    ' data to be viewed must be selected in main screen
    Debug.Assert (grd_samples.Row <> -1)
    Call Item_LoadDB(ml_DetailCursor, ITEM_CODE, Language_codeToolBar)
    If ml_DetailCursor = 0 Then
        Call Err.Raise(CompFncFailed, "", "Record was deleted or translation for language is missing." & vbCrLf & "Refresh grid, please.")
    End If
    Debug.Assert (ml_DetailCursor <> 0)
    Call ResetDetail(ml_DetailCursor)
    Call UpdateUI("SampleDoc.View")

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_ViewInit()")
End Sub


Private Sub Item_TranslateInit()
On Error GoTo ErrHandler
    ' data to be deleted must be selected in main screen
    Debug.Assert (grd_samples.Row <> -1)
    Call Item_LoadDB(ml_DetailCursor, ITEM_CODE, Language_codeToolBar)
    If ml_DetailCursor = 0 Then
        Call Err.Raise(CompFncFailed, "", "Record was deleted or translation for language is missing." & vbCrLf & "Refresh grid, please.")
    End If
    Debug.Assert (ml_DetailCursor <> 0)
    Call ResetDetail(ml_DetailCursor)
    Call UpdateUI("SampleDoc.Tran")

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_TranslateInit()")
End Sub

Private Sub UpdateGridAfterAction(ByVal ao_grid As ArmGrid, ByVal as_Action As String, ByVal av_Key As Variant)
On Error GoTo ErrHandler
    Dim ll_Index As Long
    Dim lo_Column As ArmColumn
    
    Select Case as_Action
    Case "Add"
        ' insert row at the end of grid
        Debug.Assert (ao_grid.Cols > 0)
        Dim lsa_newRow() As String
        Call SafeRedimString(lsa_newRow, ao_grid.Cols)
        Dim ll_KeyIndex As Long
        
        Call ao_grid.DeselectRow
        ll_KeyIndex = 0
        
        For ll_Index = 0 To ao_grid.Cols - 1
            Set lo_Column = ao_grid.Columns(ll_Index)
            If lo_Column.Key Then
                Debug.Assert (UBound(av_Key) >= ll_KeyIndex)
                lsa_newRow(ll_Index) = av_Key(ll_KeyIndex)
                ll_KeyIndex = ll_KeyIndex + 1
            Else
                lsa_newRow(ll_Index) = GetDataSrcForGrid(lo_Column)
            End If
        Next
        Call ao_grid.AddLine(lsa_newRow)
    Case "Upd", "Tran", "Del"
        ' search and update row in the grid
        Debug.Assert (ao_grid.Cols > 0)
        
        If Not ao_grid.SearchKey(True, av_Key) Then
            Call Err.Raise(CompFncFailed, "ao_grid.SearchKey", "Cannot update grid.")
        End If
        
        For ll_Index = 0 To ao_grid.Cols - 1
            Set lo_Column = ao_grid.Columns(ll_Index)
            If Not lo_Column.Key Then
                If Not lo_Column.SetData(ao_grid.Row, GetDataSrcForGrid(lo_Column)) Then
                    Call Err.Raise(CompFncFailed, "lo_Column.SetData", "Cannot update grid.")
                End If
            End If
        Next

'TASK 289
'    Case "Del"
'        ' remove row from grid
'        If Not ao_grid.DeleteLine(av_Key) Then
'            Call Err.Raise(CompFncFailed, "DeleteLine", "Cannot delete line.")
'        End If
    Case Else
        Debug.Assert (False)
    End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler("UpdateGridAfterAction()")
End Sub

' when updating main grid from detail
Private Function GetDataSrcForGrid(ByVal ao_Column As ArmColumn) As String
On Error GoTo ErrHandler
    Select Case ao_Column.FieldName
        Case "SD_descE"
            If Language_codeToolBar = "E" Or ao_Column.Grid.Row = -1 Then
                GetDataSrcForGrid = txt_sample.Text
            Else
                ' return original value
                GetDataSrcForGrid = ao_Column.GetData(ao_Column.Grid.Row)
            End If
        Case "SD_desc"
            GetDataSrcForGrid = txt_sample.Text
        Case "SDG_desc"
            GetDataSrcForGrid = cbo_Group.SelectedItem.GetData(1)
        Case "SDC_Code"
            GetDataSrcForGrid = cbo_Category.SelectedItem.GetData(1)
        Case "IN_USE"
            If ao_Column.Grid.Row = -1 Then
                ' allways in Add mode
                Debug.Assert (GetString(ms_activeFace, -1, ".") = "Add")
                GetDataSrcForGrid = "N"
            Else
                ' return original value
                GetDataSrcForGrid = ao_Column.GetData(ao_Column.Grid.Row)
            End If
        Case "drop_flag"
            GetDataSrcForGrid = GetInternet_flag(chk_DropFlag, 0)
            
        Case "SD_Price"
            GetDataSrcForGrid = txt_Price.Text
        Case "SD_Max"
            If Not cbo_sampleDepartment.SelectedItem Is Nothing Then
                If chk_smpDpt(cbo_sampleDepartment.SelectedItem.Key).Value = vbChecked Then
                    GetDataSrcForGrid = txt_smpMax(cbo_sampleDepartment.SelectedItem.Key).Text
                Else
                    GetDataSrcForGrid = ""
                End If
            Else
                GetDataSrcForGrid = ""
            End If
        Case "SD_MIN"
            If Not cbo_sampleDepartment.SelectedItem Is Nothing Then
                If chk_smpDpt(cbo_sampleDepartment.SelectedItem.Key).Value = vbChecked Then
                    GetDataSrcForGrid = txt_smpMin(cbo_sampleDepartment.SelectedItem.Key).Text
                Else
                    GetDataSrcForGrid = ""
                End If
            Else
                GetDataSrcForGrid = ""
            End If
        Case "SD_QTY"
            If Not cbo_sampleDepartment.SelectedItem Is Nothing Then
                If chk_smpDpt(cbo_sampleDepartment.SelectedItem.Key).Value = vbChecked Then
                    GetDataSrcForGrid = txt_smpQty(cbo_sampleDepartment.SelectedItem.Key).Text
                Else
                    GetDataSrcForGrid = ""
                End If
            Else
                GetDataSrcForGrid = ""
            End If
    End Select
    
    Exit Function
ErrHandler:
     Call ErrorHandler("GetDataSrcForGrid()")
End Function

'******************************************************************************************************
'*********************************** ITEM DB DATA MANIPULATION ****************************************
'******************************************************************************************************
Private Function Item_DeleteDB(ByVal al_SDCode As Long, ByVal al_iConcurrency As Long) As Boolean
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Cap_E_SampleDoc_del2 $SD_CODE$, $ICONCURRENCY$, '$LOGIN$'"
Const C_REQ2 As String = "EXEC Cap_SampleDoc_del2 $SD_CODE$, $ICONCURRENCY$, '$LOGIN$'"
Const C_TRAN_BEGIN As String = "BEGIN TRAN DeleteItem"
Const C_TRAN_COMMIT As String = "COMMIT TRAN DeleteItem"
Const C_TRAN_ROLLBACK As String = "ROLLBACK TRAN DeleteItem"
    Dim lb_InTrans As Boolean
    lb_InTrans = False
    Dim ls_req As String
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_BEGIN)
    lb_InTrans = True
    
    ' change Cap_E_SampleDoc
    ls_req = Replace(C_REQ, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$U_code$", ml_U_Code)
    ls_req = Replace(ls_req, "$ICONCURRENCY$", CStr(al_iConcurrency))
    ls_req = Replace(ls_req, "$LOGIN$", Login)
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_DeleteDB = False
        Exit Function
    End If

    ' change Cap_SampleDoc
    ls_req = Replace(C_REQ2, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$U_code$", ml_U_Code)
    ls_req = Replace(ls_req, "$ICONCURRENCY$", CStr(al_iConcurrency))
    ls_req = Replace(ls_req, "$LOGIN$", Login)
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_DeleteDB = False
        Exit Function
    End If

    Call ExecuteSQLSafe(mo_Db, C_TRAN_COMMIT)
    lb_InTrans = False

    Item_DeleteDB = True
    Exit Function
ErrHandler:
    If lb_InTrans Then
        Call UpdateError(True)
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Call UpdateError(False)
    End If
    Call ErrorHandler("Item_DeleteDB()")
End Function

Private Function Item_UpdateDB(ByVal al_SDCode As Long, ByVal al_iConcurrency As Long) As Boolean
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Cap_SampleDoc_upd2 $SD_CODE$, '$LANG_CODE$', $ESD_CODE$, '$txt_sample$', $txt_price$, '$CURR_CODE$', 'PC', $SDC_CODE$, '$AS_PRD$', $ICONCURRENCY$, '$INTERNET$', '$DROP$', $DROPDATE$, '$txt_spare1$', '$txt_spare2$', $txt_spare3$, $txt_spare4$,'$LOGIN$'"
Const C_REQ2 As String = "EXEC Cap_E_SampleDoc_upd2 $SD_CODE$, '$LANG_CODE$'"
Const C_TRAN_BEGIN As String = "BEGIN TRAN UpdateItem"
Const C_TRAN_COMMIT As String = "COMMIT TRAN UpdateItem"
Const C_TRAN_ROLLBACK As String = "ROLLBACK TRAN UpdateItem"
    Dim lb_InTrans As Boolean
    lb_InTrans = False
    Debug.Assert (Item_Check())
    Debug.Assert (ml_DetailCursor <> 0)
    Dim ls_req As String
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_BEGIN)
    lb_InTrans = True
    
    '1. UPDATE Cap_SampleDoc
    ls_req = Replace(C_REQ, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$LANG_CODE$", Language_codeToolBar)
    ls_req = Replace(ls_req, "$U_code$", ml_U_Code)
    ls_req = Replace(ls_req, "$ESD_CODE$", mo_Db.GetFields(ml_DetailCursor, "ESD_code"))
    ls_req = Replace(ls_req, "$txt_sample$", SQLStr(txt_sample.Text))
    ls_req = Replace(ls_req, "$txt_price$", SqlDouble(txt_Price.Text))
    ls_req = Replace(ls_req, "$CURR_CODE$", cbo_Currency.SelectedItem.Key)
    ls_req = Replace(ls_req, "$SDC_CODE$", cbo_Category.SelectedItem.Key)
    ls_req = Replace(ls_req, "$AS_PRD$", IIf(chk_ASProduct.Value = vbChecked, "X", ""))
    ls_req = Replace(ls_req, "$INTERNET$", GetInternet_flag(chk_internet, ml_DetailCursor, "internet_flag"))
    ls_req = Replace(ls_req, "$DROP$", GetInternet_flag(chk_DropFlag, ml_DetailCursor, "drop_flag"))
    ls_req = Replace(ls_req, "$DROPDATE$", SQLDateTime(0))
    ls_req = Replace(ls_req, "$txt_spare1$", SQLStr(txt_spare1.Text))
    ls_req = Replace(ls_req, "$txt_spare2$", SQLStr(txt_spare2.Text))
    ls_req = Replace(ls_req, "$txt_spare3$", txt_spare3.Text)
    ls_req = Replace(ls_req, "$txt_spare4$", txt_spare4.Text)
    ls_req = Replace(ls_req, "$ICONCURRENCY$", CStr(al_iConcurrency))
    ls_req = Replace(ls_req, "$LOGIN$", Login)
    
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_UpdateDB = False
        Exit Function
    End If
    
    '2. UPDATE Cap_E_SampleDoc
    ls_req = Replace(C_REQ2, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$LANG_CODE$", Language_codeToolBar)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_UpdateDB = False
        Exit Function
    End If

    '3. SAVE Markets
    If Not cvw_markets.SaveList Then
        Call Err.Raise(CompFncFailed, "SaveList", "List of markets cannot be saved.")
    End If
    
    ' 4. SAVE STOCK
    Call Item_StockUpdateDB(al_SDCode)

    Call ExecuteSQLSafe(mo_Db, C_TRAN_COMMIT)
    lb_InTrans = False
    
    Item_UpdateDB = True
    Exit Function
ErrHandler:
    If lb_InTrans Then
        Call UpdateError(True)
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Call UpdateError(False)
    End If
    Call ErrorHandler("Item_UpdateDB()")
End Function

' same as Item_UpdateDB but markets are not saved
Private Function Item_TranslateDB(ByVal al_SDCode As Long, ByVal al_iConcurrency As Long) As Boolean
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Cap_SampleDoc_upd2 $SD_CODE$, '$LANG_CODE$', $ESD_CODE$, '$txt_sample$', $txt_price$, '$CURR_CODE$', 'PC', $SDC_CODE$, '$AS_PRD$', $ICONCURRENCY$, '$INTERNET$', '$DROP$', $DROPDATE$, '$txt_spare1$', '$txt_spare2$', $txt_spare3$, $txt_spare4$,'$LOGIN$'"
Const C_REQ2 As String = "EXEC Cap_E_SampleDoc_upd2 $SD_CODE$, '$LANG_CODE$'"
Const C_TRAN_BEGIN As String = "BEGIN TRAN TranslateItem"
Const C_TRAN_COMMIT As String = "COMMIT TRAN TranslateItem"
Const C_TRAN_ROLLBACK As String = "ROLLBACK TRAN TranslateItem"
    Dim lb_InTrans As Boolean
    lb_InTrans = False
    Debug.Assert (Item_Check())
    Debug.Assert (ml_DetailCursor <> 0)
    Dim ls_req As String
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_BEGIN)
    lb_InTrans = True
    
    '1. UPDATE Cap_SampleDoc
    ls_req = Replace(C_REQ, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$LANG_CODE$", Language_codeToolBar)
    ls_req = Replace(ls_req, "$U_code$", ml_U_Code)
    ls_req = Replace(ls_req, "$ESD_CODE$", mo_Db.GetFields(ml_DetailCursor, "ESD_code"))
    ls_req = Replace(ls_req, "$txt_sample$", SQLStr(txt_sample.Text))
    ls_req = Replace(ls_req, "$txt_price$", SqlDouble(txt_Price.Text))
    ls_req = Replace(ls_req, "$CURR_CODE$", cbo_Currency.SelectedItem.Key)
    ls_req = Replace(ls_req, "$SDC_CODE$", cbo_Category.SelectedItem.Key)
    ls_req = Replace(ls_req, "$AS_PRD$", IIf(chk_ASProduct.Value = vbChecked, "X", ""))
    ls_req = Replace(ls_req, "$INTERNET$", mo_Db.GetFields(ml_DetailCursor, "internet_flag"))
    ls_req = Replace(ls_req, "$DROP$", mo_Db.GetFields(ml_DetailCursor, "drop_flag"))
    ls_req = Replace(ls_req, "$DROPDATE$", SQLDateTime(0))
    ls_req = Replace(ls_req, "$txt_spare1$", SQLStr(txt_spare1.Text))
    ls_req = Replace(ls_req, "$txt_spare2$", SQLStr(txt_spare2.Text))
    ls_req = Replace(ls_req, "$txt_spare3$", txt_spare3.Text)
    ls_req = Replace(ls_req, "$txt_spare4$", txt_spare4.Text)
    ls_req = Replace(ls_req, "$ICONCURRENCY$", CStr(al_iConcurrency))
    ls_req = Replace(ls_req, "$LOGIN$", Login)
    
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_TranslateDB = False
        Exit Function
    End If
    
    '2. UPDATE Cap_E_SampleDoc
    ls_req = Replace(C_REQ2, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$LANG_CODE$", Language_codeToolBar)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    If mo_Db.SQLRowsAffected <> 1 Then
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Item_TranslateDB = False
        Exit Function
    End If
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_COMMIT)
    lb_InTrans = False
    
    Item_TranslateDB = True
    Exit Function
ErrHandler:
    If lb_InTrans Then
        Call UpdateError(True)
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Call UpdateError(False)
    End If
    Call ErrorHandler("Item_TranslateDB()")
End Function

Private Sub Item_StockUpdateDB(ByVal al_SD_Code As Long)
On Error GoTo ErrHandler
Const C_REQ_INS As String = "EXEC Cap_SampleDoc_Department_ins $SD_CODE$, $SDP_CODE$, $txt_smpQty$, $txt_smpMin$, $txt_smpMax$, $U_CODE$"
Const C_REQ_UPD As String = "EXEC Cap_SampleDoc_Department_upd $SD_CODE$, $SDP_CODE$, $txt_smpQty$, $txt_smpMin$, $txt_smpMax$, $U_CODE$, $ICONC$"
Const C_REQ_DEL As String = "EXEC Cap_SampleDoc_Department_del $SD_CODE$, $SDP_CODE$, $ICONC$"


Const C_REQ_TRAN_INS As String = "EXEC Cap_SampleDoc_Transaction_ins NULL,$SD_CODE$,$SDP_CODE$,$QTY$,$QTY_TOTAL$,$U_CODE$"

    
    Dim lo_cbo As Object
    Dim ll_SPD_Code As Long
    Dim ls_req As String
    
    For Each lo_cbo In cbo_UOM
        ll_SPD_Code = lo_cbo.Index
        ls_req = ""
        
        If mo_userRights.StockDepartment = ll_SPD_Code Then
        
            If chk_smpDpt(ll_SPD_Code).Value = vbChecked Then
                ' add or update
                ls_req = IIf(btn_qtyAddj(ll_SPD_Code).Tag = 0, C_REQ_INS, C_REQ_UPD)
            Else
                ' delete or no action
                ls_req = IIf(btn_qtyAddj(ll_SPD_Code).Tag = 0, "", C_REQ_DEL)
            End If
            
            If ls_req <> "" Then
            
                ls_req = Replace(ls_req, "$SD_CODE$", al_SD_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$SDP_CODE$", ll_SPD_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$txt_smpQty$", SqlInt(txt_smpQty(ll_SPD_Code).Text, "0"), , , vbTextCompare)
                ls_req = Replace(ls_req, "$txt_smpMin$", SqlInt(txt_smpMin(ll_SPD_Code).Text), , , vbTextCompare)
                ls_req = Replace(ls_req, "$txt_smpMax$", SqlInt(txt_smpMax(ll_SPD_Code).Text), , , vbTextCompare)
                ls_req = Replace(ls_req, "$U_CODE$", ml_U_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$ICONC$", SqlInt(btn_qtyAddj(ll_SPD_Code).Tag, "0"), , , vbTextCompare)
                
                Call ExecuteSQLSafe(mo_Db, ls_req)
                
                Dim ll_qty As Long
                ll_qty = 0
                If txt_smpQty(ll_SPD_Code).Tag <> "" Then
                    ll_qty = CLng(txt_smpQty(ll_SPD_Code).Tag)
                End If
                
                If (Trim(txt_smpQty(ll_SPD_Code).Text) = "") Or (chk_smpDpt(ll_SPD_Code).Value <> vbChecked) Then
                    ll_qty = -ll_qty
                Else
                    ll_qty = CLng(txt_smpQty(ll_SPD_Code).Text) - ll_qty
                End If
                
                ' Insert record into transaction table
                ls_req = Replace(C_REQ_TRAN_INS, "$SD_CODE$", al_SD_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$SDP_CODE$", ll_SPD_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$U_CODE$", ml_U_Code, , , vbTextCompare)
                ls_req = Replace(ls_req, "$QTY$", SqlInt(ll_qty), , , vbTextCompare)
                ls_req = Replace(ls_req, "$QTY_TOTAL$", SqlInt(txt_smpQty(ll_SPD_Code).Text, "0"), , , vbTextCompare)
                
                Call ExecuteSQLSafe(mo_Db, ls_req)
                
            End If
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_StockUpdateDB()")
End Sub


Private Sub Item_AddDB(ByVal al_SDCode As Long)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Cap_E_SampleDoc_ins2 $SD_CODE$, $SDG_CODE$, '$txt_sample$', '$INTERNET$', '$DROP$', $DROPDATE$, '$txt_spare1$', '$txt_spare2$', $txt_spare3$, $txt_spare4$, '$LOGIN$'"
Const C_REQ2 As String = "EXEC Cap_SampleDoc_ins2 $SD_CODE$, $txt_price$, '$CURR_CODE$', 'PC', $SDC_CODE$, '$AS_PRD$'"
Const C_TRAN_BEGIN As String = "BEGIN TRAN InsertItem"
Const C_TRAN_COMMIT As String = "COMMIT TRAN InsertItem"
Const C_TRAN_ROLLBACK As String = "ROLLBACK TRAN InsertItem"
    Dim lb_InTrans As Boolean
    lb_InTrans = False
    Debug.Assert (Item_Check())
    Dim ls_req As String
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_BEGIN)
    lb_InTrans = True
    
    ' 1. INSERT Cap_E_SampleDoc
    ls_req = Replace(C_REQ, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$SDG_CODE$", cbo_Group.SelectedItem.Key)
    ls_req = Replace(ls_req, "$U_code$", ml_U_Code)
    ls_req = Replace(ls_req, "$txt_sample$", SQLStr(txt_sample.Text))
    ls_req = Replace(ls_req, "$INTERNET$", GetInternet_flag(chk_internet, 0))
    ls_req = Replace(ls_req, "$DROP$", "")
    ls_req = Replace(ls_req, "$DROPDATE$", SQLDateTime(0))
    ls_req = Replace(ls_req, "$txt_spare1$", SQLStr(txt_spare1.Text))
    ls_req = Replace(ls_req, "$txt_spare2$", SQLStr(txt_spare2.Text))
    ls_req = Replace(ls_req, "$txt_spare3$", txt_spare3.Text)
    ls_req = Replace(ls_req, "$txt_spare4$", txt_spare4.Text)
    ls_req = Replace(ls_req, "$LOGIN$", Login)

    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    If mo_Db.SQLRowsAffected <> 1 Then
        Call Err.Raise(CompFncFailed, "", "Cannot insert values into Cap_E_SampleDoc.")
    End If
    
    ' 2. INSERT Cap_SampleDoc - copy from Cap_SampleDoc
    ls_req = Replace(C_REQ2, "$SD_CODE$", CStr(al_SDCode))
    ls_req = Replace(ls_req, "$txt_price$", SqlDouble(txt_Price.Text))
    ls_req = Replace(ls_req, "$CURR_CODE$", cbo_Currency.SelectedItem.Key)
    ls_req = Replace(ls_req, "$SDC_CODE$", cbo_Category.SelectedItem.Key)
    ls_req = Replace(ls_req, "$AS_PRD$", IIf(chk_ASProduct.Value = vbChecked, "X", ""))
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    If mo_Db.SQLRowsAffected <> 1 Then
        Call Err.Raise(CompFncFailed, "", "Cannot insert values into Cap_SampleDoc.")
    End If
    
    
    ' 3. SAVE markets
    cvw_markets.Calling_Key_Values = CStr(al_SDCode) & SEP & ms_Language_Code & SEP & ml_U_Code
    If Not cvw_markets.SaveList Then
        Call Err.Raise(CompFncFailed, "SaveList", "List of markets cannot be saved.")
    End If

    ' 4. SAVE STOCK
    Call Item_StockUpdateDB(al_SDCode)

    Call ExecuteSQLSafe(mo_Db, C_TRAN_COMMIT)
    lb_InTrans = False

    Exit Sub
ErrHandler:
    If lb_InTrans Then
        Call UpdateError(True)
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Call UpdateError(False)
    End If
    Call ErrorHandler("Item_AddDB()")
End Sub

Private Function GetInternet_flag(ByRef ao_check As CheckBox, ByVal al_cursor As Long, Optional ByVal as_DBiFlagName As String = "internet_flag") As String
On Error GoTo ErrHandler
    Select Case ao_check.Value
        Case CheckBoxConstants.vbChecked
            GetInternet_flag = "X"
        Case CheckBoxConstants.vbUnchecked
            GetInternet_flag = ""
        Case CheckBoxConstants.vbGrayed
            ' return original value from cursor -- this must be part of opened cursor
            If al_cursor <> 0 Then
                If mo_Db.GetFieldIndex(al_cursor, as_DBiFlagName) Then
                    GetInternet_flag = mo_Db.GetFields(al_cursor, as_DBiFlagName)
                Else
                    Call Err.Raise(ArmErr.InvalidValue, "", "Field " & as_DBiFlagName & " is not part of record.")
                End If
            End If
        Case Else
            Debug.Assert (False)
    End Select
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetInternet_flag()")
End Function

' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$LANG_CODE$'"
    Dim ls_req As String
    Dim ll_Cursor As Long
    Dim ll_CodePage As Long
    
    ls_req = Replace(C_REQ, "$LANG_CODE$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_CodePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_CodePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function


'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Function GetLCIDFromCodePage(ByVal al_CodePage As Long) As Long

    On Error GoTo Trace_Err

    Select Case al_CodePage
        Case 932 ' Japanese
            GetLCIDFromCodePage = 1041
        Case 936 ' Simplified Chinese
            GetLCIDFromCodePage = 2052
        Case 949 ' Korean
            GetLCIDFromCodePage = 1042
        Case 950 ' Traditional Chinese
            GetLCIDFromCodePage = 1028
        Case 1250 ' Eastern Europe
            GetLCIDFromCodePage = 1045
        Case 1251  ' Russian
            GetLCIDFromCodePage = 1049
        Case 1252  ' Western European Languages
            GetLCIDFromCodePage = 1033
        Case 1253 ' Greek
            GetLCIDFromCodePage = 1032
        Case 1254 ' Turkish
            GetLCIDFromCodePage = 1055
        Case 1255 ' Hebrew
            GetLCIDFromCodePage = 1037
        Case 1256 ' Arabic
            GetLCIDFromCodePage = 1025
        Case 1257 ' Baltic
            GetLCIDFromCodePage = 1061
        Case Else
            GetLCIDFromCodePage = 1033
    End Select
    
    Exit Function
    
Trace_Err:
    Call ErrorHandler("GetLCIDFromCodePage()")

End Function


Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As String = "")

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ls_Charset As String
    
    On Error Resume Next
    If aCodePage = "" Then
'    ls_Charset = GetCharSetFromCodePage(GetDefaultConfigCode("Capture_Cfg", "Charset"))
    ls_Charset = GetCharSetFromCodePage(aCodePage)
    Else
        ls_Charset = GetCharSetFromCodePage(aCodePage)
    End If
    
    If ls_Charset <> "" Then
        For Each lc_Control In ao_Container
            Select Case UCase(TypeName(lc_Control))
            Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
                  "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
                  "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
                lc_Control.Font.Name = "Arial"
                lc_Control.Font.Charset = ls_Charset
            Case "A_SEEK", "A_SRCHTXT"
                lc_Control.Charset = ls_Charset
            End Select
        Next
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler("LoadLabels")
    
End Sub


' ************************************************************************************

'******************** REDIM FUNCTION **********************************
Sub SafeRedimString(ByRef as_Array() As String, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim as_Array(-1 To -1)
  Else
          ReDim Preserve as_Array(al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler("SafeRedimString()")
End Sub

Sub SafeRedim(ByRef av_Array() As Variant, al_NumElements As Long)

On Error GoTo ErrHandler

  If al_NumElements = 0 Then
          ReDim av_Array(-1 To -1)
  Else
          ReDim Preserve av_Array(al_NumElements - 1)
  End If
  Exit Sub
ErrHandler:
    Call ErrorHandler("SafeRedim()")
End Sub
' ************************************************************************************


' ************************************************************************************
' **************************** DB-ACCESS FUNCTIONS ***********************************
' ************************************************************************************
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_Db As Object, ByVal as_req As String)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_req As String)
#End If

    If Not ao_Db.ExecuteSQL(as_req) Then
        Call Err.Raise(CompFncFailed, "ExecuteSQLSafe", "SQL Error: " & GetDbError(ao_Db))
    End If

End Sub

#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_req As String) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_req As String) As Long
#End If

    OpenSQLSafe = ao_Db.OpenSQL(as_req)
    
    If OpenSQLSafe = 0 Then Call Err.Raise(CompFncFailed, "OpenSQLSafe", "SQL Error: " & GetDbError(ao_Db))

End Function

Private Function SqlInt(ByVal as_Double As String, Optional ByVal as_ifEmpty As String = "NULL") As String
On Error GoTo ErrHandler
    If as_Double = "" Then
        SqlInt = as_ifEmpty
    Else
        SqlInt = Str(CLng(as_Double))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLInt")
End Function

Private Function SqlDouble(ByVal as_Double As String, Optional ByVal as_ifEmpty As String = "0") As String
On Error GoTo ErrHandler
    If as_Double = "" Then
        SqlDouble = as_ifEmpty
    Else
        SqlDouble = Str(CDbl(as_Double))
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLDouble")
End Function

' safe retieving selected item from combobox
Private Function SQLComboBoxValue(ByRef ao_Combobox As ArmCombobox, Optional ByVal as_DefaultValue As String = "NULL", Optional ByVal ab_KeyTitle As Boolean = True) As String
On Error GoTo ErrHandler
    If ao_Combobox.SelectedItem Is Nothing Then
        SQLComboBoxValue = as_DefaultValue
    Else
        If IsEmpty(ao_Combobox.SelectedItem.Key) Then
            SQLComboBoxValue = as_DefaultValue
        Else
            SQLComboBoxValue = IIf(ab_KeyTitle, ao_Combobox.SelectedItem.Key, ao_Combobox.SelectedItem.DisplayText)
        End If
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".SQLComboBoxValue")
End Function

Private Function SQLDateTime(ad_Date As Date) As String
On Error GoTo ErrHandler
  If ad_Date = 0 Then
    SQLDateTime = "Null"
  Else
    SQLDateTime = "{ ts '" & Format(ad_Date, "yyyy-mm-dd hh:mm:ss") & "'}"
  End If
    Exit Function
ErrHandler:
     Call ErrorHandler(Extender.Name & ".SQLDateTime")
End Function

Private Function SQLStr(ByVal as_str As String) As String
    SQLStr = Replace(as_str, "'", "''")
End Function
' ************************************************************************************


' ************************************************************************************
' ********************** ERROR-HANDLING SUPPORT FUNCTIONS ****************************
' ************************************************************************************
#If LIVE = 1 Then
Private Function GetDbError(ByVal lo_Db As Object) As String
#Else
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
#End If
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    If Err.Number = QuietException Then Exit Sub
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    
    Call LogMessage(App.ProductName & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_errDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT" & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, , "Error message: " & as_Fct)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Private Sub FieldErrorMsg(ByVal al_msgID As Long, ByVal as_caption As String, ByVal ao_Field As Object, Optional ByVal as_min As String = "", Optional ByVal as_max As String = "")

    Dim ls_Buffer As String
    Dim ll_oldMP As MousePointerConstants
    
    'save mouse pointer
    ll_oldMP = Screen.MousePointer
    Screen.MousePointer = vbDefault
    
    ls_Buffer = MsgText(al_msgID, ms_Language_Code, "#Error in $field$.")
    ls_Buffer = Replace(ls_Buffer, "$field$", as_caption)
    ls_Buffer = Replace(ls_Buffer, "$LabelCaption$", as_caption)
    ls_Buffer = Replace(ls_Buffer, "$Min$", as_min)
    ls_Buffer = Replace(ls_Buffer, "$Max$", as_max)
    
    ao_Field.SetFocus
    Call MsgBox(ls_Buffer, vbOKOnly + vbCritical)
    
    'restore mouse pointer
    Screen.MousePointer = ll_oldMP
End Sub

Public Function MsgText(ByVal ai_MsgID As Integer, ByVal as_LanguageCode As String, ByVal as_defaultMsg As String) As String
'------------------------------------------------------------------
' Name : MsgText
'
' Purpose : Read the message in the database with the login
'           language
'
' Parameters :
'       ai_MsgId            Code of the message to find in the
'                               database
'       as_LanguageCode     Language Code to use to find the text
'
' Return :
'       The message in the good language
'
' review : Mar/20/2000 by AD
'------------------------------------------------------------------
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT message_text FROM error_message WHERE msgid=$MSGID$ AND Language_code='$LANG_CODE$'"
    Dim ls_req As String
    Dim ls_ret As String
    Dim ll_Cursor As Long
    
    ls_ret = as_defaultMsg
    ls_req = Replace(C_REQ, "$MSGID$", ai_MsgID)
    ls_req = Replace(ls_req, "$LANG_CODE$", as_LanguageCode)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    Debug.Assert (ll_Cursor <> 0)
    
    Call mo_Db.First(ll_Cursor)
    While Not mo_Db.EOF(ll_Cursor)
        ls_ret = IIf(ls_ret = "", "", ls_ret & vbCrLf) & mo_Db.GetFields(ll_Cursor, "message_text")
        Call mo_Db.Next(ll_Cursor)
    Wend
    Call mo_Db.Close(ll_Cursor)
    MsgText = ls_ret
    Exit Function
ErrHandler:
    If ll_Cursor <> 0 Then Call mo_Db.Close(ll_Cursor)
    Call ErrorHandler("MsgText()")
End Function


Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "INSERT INTO A_Log (U_code, Z_creation_date, Source , Log_type, Log_Msg ) VALUES ($UCODE$, GETDATE(), '$APP$', '$LOGTYPE$', '$MSG$')"
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_U_Code))
    ls_req = Replace(ls_req, "$APP$", SQLStr(App.ProductName & " " & App.Major & "." & App.Minor & "." & App.Revision))
    ls_req = Replace(ls_req, "$MSG$", SQLStr(as_logMsg))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType))
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
ErrHandler:
    If ab_throwException Then Call ErrorHandler("LogMessage()")
End Sub

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub
' ************************************************************************************

Private Sub btn_qtyAddj_Click(Index As Integer)
On Error GoTo ErrHandler
    
    Dim lb_checkboxUpdated As Boolean
    Dim lb_qtyUpdated As Boolean
    
    lb_checkboxUpdated = False
    
    If chk_smpDpt(Index).Value <> vbChecked Then
        chk_smpDpt(Index).Value = vbChecked             ' it will raise the event
        lb_checkboxUpdated = True
    End If
    
    Dim ls_val As String
    Dim ll_errCode As Long
    
    ls_val = InputBox("Enter qty to add", "Stock qty upd", "1")
    If ls_val <> "" Then
        txt_smpQty(0).Text = ls_val
        
        ll_errCode = CheckNumericField(txt_smpQty(0), 0, -99999999, 99999999)
        If ll_errCode <> 0 Then
            Call MsgBox(MsgText(985, ms_Language_Code, "#Quantity must be between -99999999 and 99999999."), vbOKOnly)
            Exit Sub
        End If
        
        Dim ld_value As Double
        ld_value = CDbl(txt_smpQty(Index).Text) + CDbl(ls_val)
        Dim ld_min As Double
        Dim ld_max As Double
        
        If ld_value < 0 Then
            Call MsgBox(MsgText(994, ms_Language_Code, "#Total quantity cant be less than 0"), vbOKOnly Or vbCritical)
            ld_value = CDbl(txt_smpQty(Index).Text)
        End If
        
        If txt_smpMin(Index).Text <> "" Then
            If CheckNumericField(txt_smpMin(Index), 0, 0, 99999999) <> 0 Then
                Call MsgBox(MsgText(986, ms_Language_Code, "#Min value must be positive number."), vbOKOnly)
                If isNumeric(txt_smpMin(Index).Text) Then
                    txt_smpMin(Index).Text = CLng(txt_smpMin(Index).Text)
                Else
                    Exit Sub
                End If
            End If
            If ld_value < CDbl(txt_smpMin(Index).Text) Then
                Call MsgBox(MsgText(987, ms_Language_Code, "#Warning: Quantity is less than Min."), vbInformation Or vbOKOnly)
            End If
        End If
        
        If txt_smpMax(Index).Text <> "" Then
            If CheckNumericField(txt_smpMax(Index), 0, 1, 99999999) <> 0 Then
                Call MsgBox(MsgText(988, ms_Language_Code, "#Max value must be positive number."), vbOKOnly)
                If isNumeric(txt_smpMax(Index).Text) Then
                    txt_smpMax(Index).Text = CLng(txt_smpMax(Index).Text)
                Else
                    Exit Sub
                End If
            End If
            If ld_value > CDbl(txt_smpMax(Index)) Then
                Call MsgBox(MsgText(989, ms_Language_Code, "#Warning Quantity is more than Max."), vbInformation Or vbOKOnly)
            End If
        End If
        
        txt_smpQty(Index).Text = ld_value
        
    ElseIf lb_checkboxUpdated Then
        chk_smpDpt(Index).Value = vbUnchecked             ' it will raise the event
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage("btn_qtyAddj_Click()")
End Sub

Private Sub cbo_dropped_ComboItemSelected()
On Error GoTo ErrHandler
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_dropped_ComboItemSelected()")
End Sub

Private Sub cbo_group_ComboItemSelected()
On Error GoTo ErrHandler
    If mInitializing Then Exit Sub

    Call cbo_Category.Clear
    If cbo_Group.SelectedItem Is Nothing Then Exit Sub
    
    cbo_Category.Request = "EXEC Cap_SampleDocCategory_lst " & cbo_Group.SelectedItem.Key & ",'" & ms_Language_Code & "'"
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_market_ComboItemSelected()")
End Sub

Private Sub cbo_market_ComboItemSelected()
On Error GoTo ErrHandler
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_market_ComboItemSelected()")
End Sub

Private Sub cbo_sampleDepartment_ComboItemSelected()
On Error GoTo ErrHandler
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_sampleDepartment_ComboItemSelected()")
End Sub

Private Sub cbo_SmpCategory_ComboItemSelected()
On Error GoTo ErrHandler
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_SmpCategory_ComboItemSelected()")
End Sub

Private Sub cbo_SmpType_ComboItemSelected()
On Error GoTo ErrHandler

    cbo_SmpCategory.Request = "EXEC Cap_SampleDocCategory_lst " & GetDBItemValue(SDG_CODE) & ",'" & ms_Language_Code & "'"
    Call cbo_SmpCategory.Load
    
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_SmpType_ComboItemSelected()")
End Sub


Private Sub cbo_yearFoAct_ComboItemSelected()
On Error GoTo ErrHandler
    Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
    Exit Sub
ErrHandler:
    Call ErrorMessage("cbo_yearFoAct_ComboItemSelected()")
End Sub

Private Sub chk_smpDpt_Click(Index As Integer)
    Static lb_lock As Boolean
    If lb_lock Then Exit Sub
    
    If mInitializing Then Exit Sub

    If Index <> mo_userRights.StockDepartment Then
        ' move back value
        lb_lock = True
        chk_smpDpt(Index).Value = IIf(chk_smpDpt(Index).Value = vbChecked, vbUnchecked, vbChecked)
        lb_lock = False
        Exit Sub
    End If
    
    If chk_smpDpt(Index).Value = vbChecked Then
        If txt_smpQty(Index).Text = "" Then
            txt_smpQty(Index).Text = C_DFT_QTY
        End If
        If txt_smpMin(Index).Text = "" Then
            txt_smpMin(Index).Text = C_DFT_MIN
        End If
        If txt_smpMax(Index).Text = "" Then
            txt_smpMax(Index).Text = C_DFT_MAX
        End If
    Else
        If txt_smpQty(Index).Text = C_DFT_QTY Then
            txt_smpQty(Index).Text = ""
        End If
        If txt_smpMin(Index).Text = C_DFT_MIN Then
            txt_smpMin(Index).Text = ""
        End If
        If txt_smpMax(Index).Text = C_DFT_MAX Then
            txt_smpMax(Index).Text = ""
        End If
    End If
    
    Call SetEnabledCtrl(txt_smpMin(Index), chk_smpDpt(Index).Value = vbChecked)
    Call SetEnabledCtrl(txt_smpMax(Index), chk_smpDpt(Index).Value = vbChecked)
    Call SetEnabledCtrl(btn_qtyAddj(Index), chk_smpDpt(Index).Value = vbChecked)
End Sub

Private Sub grd_samples_ItemSelected()
On Error GoTo ErrHandler
        If grd_samples.Row <> -1 Then
            Call Item_ViewInit
        End If
    Exit Sub
ErrHandler:
    Screen.MousePointer = vbDefault
    Call ErrorMessage("grd_samples_ItemSelected()")
End Sub

Private Sub tlb_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Screen.MousePointer = vbHourglass
    Select Case as_Role
    Case "A"              ' ADD
        Debug.Assert (ml_DetailCursor = 0)
        Call Item_AddInit
    Case "E"              ' EDIT
        If grd_samples.Row <> -1 Then
            If as_Language = "E" Then
                Call Item_UpdateInit
            Else
                Call Item_TranslateInit
            End If
        End If
    Case "S"                ' TRANSLATE
        If grd_samples.Row <> -1 Then
            'Call Item_TranslateInit
        End If
    Case "D"              ' DELETE
        If grd_samples.Row <> -1 Then
            If grd_samples.SelectedLine(0, "DROPFLAG") <> "X" Then
            Call Item_DeleteInit
            Else
                MsgBox ("Record is already deleted.")
            End If
        End If
    Case "L"              ' LANGUAGE SELECTED FROM COMBO
        Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, True)
        Call ApplyRights(mo_userRights, Language_codeToolBar)
    Case "H"              ' ACCEPT CHANGES
        Dim ls_SDcode As String
        Select Case GetString(ms_activeFace, -1, ".")
        Case "Add"
            ls_SDcode = Item_Add()
        Case "Upd"
            Debug.Assert (grd_samples.Row <> -1)
            ls_SDcode = Item_Update()
        Case "Tran"
            Debug.Assert (grd_samples.Row <> -1)
            ls_SDcode = Item_Translate()
        Case "Del"
            Debug.Assert (ml_DetailCursor <> 0)
            ls_SDcode = Item_Delete()
        Case Else
            Debug.Assert (False)
        End Select
        If ls_SDcode <> "" Then
            Debug.Assert (isNumeric(ls_SDcode))
            Call Item_ExitToGrid(CVar(Array(ls_SDcode)))
        End If
    Case "I"              ' CLEAR CHANGES
        Call ResetDetail(ml_DetailCursor)
    Case "R"              ' REFRESH TABLE GRID
        Call FillSampleGrid(grd_samples, SDG_CODE, SDC_CODE, LMK_CODE, SPD_Code, Language_codeToolBar, False)
    Case "T"              ' CLOSE SCREEN/CANCEL
        ' close detailCursor
        Call mo_Db.Close(ml_DetailCursor)
        ml_DetailCursor = 0
        Call UpdateUI("SampleDoc.Main")
    Case "Q"              ' QUIT
        RaiseEvent quit
    End Select

    Screen.MousePointer = vbDefault
    Exit Sub
ErrHandler:
    Screen.MousePointer = vbDefault
    Call ErrorMessage("tlb_main_Action()")
End Sub

Private Function GetDBItemValue(ByVal al_Value As Long) As String
On Error GoTo ErrHandler
    GetDBItemValue = ""
    
    If al_Value = 0 Then
        GetDBItemValue = "NULL"
        Exit Function
    End If
    
    GetDBItemValue = al_Value
    Exit Function

ErrHandler:
    Call ErrorHandler("GetDBItemValue()")
End Function

Private Sub SetCboItem(ByVal al_cursor As Long, ByRef ao_Cbo As Object)
On Error GoTo ErrHandler
    If Not ao_Cbo.SearchItem(mo_Db.GetFields(al_cursor, GetString(ao_Cbo.Tag, 0, SEP1)), 0) Then
        Call ao_Cbo.AddItem(Array(mo_Db.GetFields(al_cursor, GetString(ao_Cbo.Tag, 0, SEP1)), mo_Db.GetFields(al_cursor, GetString(ao_Cbo.Tag, 1, SEP1))), True)
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("SetCboItem()")
End Sub

Private Sub txt_smpMax_Change(Index As Integer)
On Error GoTo ErrHandler
    If mInitializing Then Exit Sub
    If txt_smpMax(Index).Text = "" Then Exit Sub
    
'    If CheckNumericField(txt_smpMax(Index), 0, 1, 9999999) <> 0 Then
'        Call MsgBox(MsgText(988, ms_Language_Code, "#Max value must be positive number."), vbOKOnly)
'        Exit Sub
'    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("txt_smpMax_Change()")
End Sub

Private Sub txt_smpMin_Change(Index As Integer)
On Error GoTo ErrHandler
    If mInitializing Then Exit Sub
    If txt_smpMin(Index).Text = "" Then Exit Sub
    
 '   If CheckNumericField(txt_smpMin(Index), 0, 0, 9999999) <> 0 Then
 '       Call MsgBox(MsgText(986, ms_Language_Code, "#Min value must be positive number."), vbOKOnly)
 '       Exit Sub
 '   End If
    Exit Sub
ErrHandler:
    Call ErrorMessage("txt_smpMin_Change()")
End Sub

